/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.ui;

import com.japisoft.editix.action.search.DisplayOccurencesAction;
import com.japisoft.editix.action.xml.refactor.RefactorConvertAttributeToElementAction;
import com.japisoft.editix.action.xml.refactor.RefactorConvertAttributesToElementAction;
import com.japisoft.editix.action.xml.refactor.RefactorCustomAction;
import com.japisoft.editix.action.xml.refactor.RefactorDeleteAttributeAction;
import com.japisoft.editix.action.xml.refactor.RefactorDeleteCommentsAction;
import com.japisoft.editix.action.xml.refactor.RefactorDeleteElementAction;
import com.japisoft.editix.action.xml.refactor.RefactorDeleteElementInNamespaceAction;
import com.japisoft.editix.action.xml.refactor.RefactorDeletePrefixAction;
import com.japisoft.editix.action.xml.refactor.RefactorDeleteTextAction;
import com.japisoft.editix.action.xml.refactor.RefactorInsertAttributeAction;
import com.japisoft.editix.action.xml.refactor.RefactorInsertElementAction;
import com.japisoft.editix.action.xml.refactor.RefactorInsertTextAction;
import com.japisoft.editix.action.xml.refactor.RefactorRenameAttributeAction;
import com.japisoft.editix.action.xml.refactor.RefactorRenameAttributeValueAction;
import com.japisoft.editix.action.xml.refactor.RefactorRenameElementAction;
import com.japisoft.editix.action.xml.refactor.RefactorRenameElementNamespaceAction;
import com.japisoft.editix.action.xml.refactor.RefactorRenameElementPrefixAction;
import com.japisoft.editix.action.xml.refactor.RefactorSurroundElementAction;
import com.japisoft.editix.ui.EditixErrorPanel;
import com.japisoft.editix.ui.EditixFactory;
import com.japisoft.editix.ui.EditixFrame;
import com.japisoft.editix.ui.EditixNodeLocationBar;
import com.japisoft.editix.ui.EditixNodeLocationListener;
import com.japisoft.editix.ui.EditixStatusBar;
import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.framework.preferences.Preferences;
import com.japisoft.framework.xml.refactor2.AbstractRefactor;
import com.japisoft.xmlpad.CaretListener;
import com.japisoft.xmlpad.DocumentStateListener;
import com.japisoft.xmlpad.IXMLPanel;
import com.japisoft.xmlpad.LocationEvent;
import com.japisoft.xmlpad.LocationListener;
import com.japisoft.xmlpad.ToolBarModel;
import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xmlpad.action.edit.CopyNodeAction;
import com.japisoft.xmlpad.action.edit.CutNodeAction;
import com.japisoft.xmlpad.action.edit.SelectTagAction;
import com.japisoft.xmlpad.error.ErrorListener;
import com.japisoft.xmlpad.tree.renderer.FastTreeRenderer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Timer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.tree.TreePath;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabbedContainer;

public class EditixXMLContainer
extends XMLContainer
implements LocationListener,
DocumentStateListener,
CaretListener,
ErrorListener,
MouseListener,
EditixNodeLocationListener {
    Timer t = null;
    private boolean firstError = true;
    private IconErrorProxy iep = null;

    public EditixXMLContainer() {
        super(true);
        this.getUIAccessibility().setToolBarAvailable(false);
        this.setStatusBarAvailable(false);
        this.getUIAccessibility().setPopupAvailable(false);
        this.getUIAccessibility().setTreePopupAvailable(false);
        this.setAutoNewDocument(false);
        this.setErrorPanelAvailable(true);
        this.getUIAccessibility().setErrorView(new EditixErrorPanel());
        this.setDisposeAction(false);
        ArrayList arrayList = EditixFrame.ACCESSOR.getBuilder().getModel("TREE");
        if (arrayList == null) {
            this.getUIAccessibility().setTreeToolBarAvailable(false);
        }
        this.getDocument().putProperty("tabSize", new Integer(Preferences.getPreference("file", "tab-size", 2)));
    }

    protected void resetDefaultTreeToolBarModel(ToolBarModel toolBarModel) {
        ArrayList arrayList = EditixFrame.ACCESSOR.getBuilder().getModel("TREE");
        if (toolBarModel != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                toolBarModel.addAction((Action)arrayList.get(i));
            }
        }
    }

    protected double getInitialDividerLocation() {
        double d = (double)Preferences.getPreference("editor", "dividerLocation", 20) / 100.0;
        if (d >= 1.0) {
            d = 0.2;
        }
        return d;
    }

    public void addNotify() {
        this.setLocationListener(this);
        this.addDocumentStateListener(this);
        this.setCaretListener(this);
        this.getErrorManager().addErrorListener(this);
        if (this.getTree() != null) {
            this.getTree().addMouseListener(this);
        }
    }

    public void removeNotify() {
        this.unsetLocationListener();
        this.removeDocumentStateListener(this);
        this.unsetCaretListener();
        this.getErrorManager().removeErrorListener(this);
        if (this.getTree() != null) {
            this.getTree().removeMouseListener(this);
        }
    }

    public void dispose() {
        super.dispose();
        ((EditixNodeLocationBar)this.sp1.getColumnHeader().getView()).dispose();
        if (this.sp2 != null) {
            ((EditixNodeLocationBar)this.sp2.getColumnHeader().getView()).dispose();
        }
    }

    public void setUIReady(boolean bl) {
        super.setUIReady(bl);
        if (bl) {
            this.addNotify();
        } else {
            this.removeNotify();
        }
    }

    protected JScrollPane prepareScrollPaneTextEditor(JComponent jComponent) {
        JScrollPane jScrollPane = super.prepareScrollPaneTextEditor(jComponent);
        jScrollPane.setColumnHeaderView(new EditixNodeLocationBar(this));
        return jScrollPane;
    }

    public void gotoNode(SimpleNode simpleNode) {
        if (simpleNode != null) {
            this.getEditor().setCaretPosition(simpleNode.getStartingOffset() + 1);
        }
    }

    public void copyNode(SimpleNode simpleNode) {
        if (simpleNode != null) {
            CopyNodeAction.copyAction(this, simpleNode);
        }
    }

    public void cutNode(SimpleNode simpleNode) {
        if (simpleNode != null) {
            CutNodeAction.cutAction(this, simpleNode);
        }
    }

    public void selectNode(SimpleNode simpleNode) {
        if (simpleNode != null) {
            SelectTagAction.selectNode(this, simpleNode);
        }
    }

    public void locationChanged(LocationEvent locationEvent) {
        EditixStatusBar.ACCESSOR.setXPathLocation(locationEvent.getXPathLocation());
        if (this.getEditor() != null) {
            EditixNodeLocationBar editixNodeLocationBar = (EditixNodeLocationBar)this.sp1.getColumnHeader().getView();
            editixNodeLocationBar.setCurrentNode(locationEvent.getDocumentLocation());
            if (this.sp2 != null) {
                editixNodeLocationBar = (EditixNodeLocationBar)this.sp2.getColumnHeader().getView();
                editixNodeLocationBar.setCurrentNode(locationEvent.getDocumentLocation());
            }
        }
    }

    public void documentModified(XMLContainer xMLContainer) {
        EditixFrame.ACCESSOR.documentModified(this);
    }

    public void newDocument(XMLContainer xMLContainer) {
        EditixFrame.ACCESSOR.documentUnModified(this);
    }

    public void initErrorProcessing() {
        this.firstError = true;
    }

    private void resetErrorIcon(boolean bl) {
        Container container;
        TabbedContainer tabbedContainer = null;
        JComponent jComponent = container = this.getView();
        while (container != null) {
            if ((container = container.getParent()) instanceof TabbedContainer) {
                tabbedContainer = (TabbedContainer)container;
                break;
            }
            if (!(container instanceof IXMLPanel)) continue;
            jComponent = container;
        }
        if (tabbedContainer != null) {
            for (int i = 0; i < tabbedContainer.getTabCount(); ++i) {
                if (tabbedContainer.getComponentAt(i) != jComponent) continue;
                TabData tabData = tabbedContainer.getModel().getTab(i);
                if (bl) {
                    if (tabData.getIcon() instanceof IconErrorProxy) break;
                    if (this.iep == null || this.getDocumentInfo().getDocumentIcon() != this.iep.getSource()) {
                        this.iep = new IconErrorProxy(this.getDocumentInfo().getDocumentIcon());
                    }
                    tabbedContainer.getModel().setIcon(i, this.iep);
                    break;
                }
                if (!(tabData.getIcon() instanceof IconErrorProxy) || this.iep == null) break;
                tabbedContainer.getModel().setIcon(i, this.iep.getSource());
                break;
            }
        }
    }

    public void notifyError(Object object, boolean bl, String string, int n, int n2, int n3, String string2, boolean bl2) {
        this.resetErrorIcon(true);
        if (bl2) {
            EditixStatusBar.ACCESSOR.setError(object, bl, string, string2, n);
            if (this.firstError && bl) {
                this.getEditor().highlightErrorLine(n + 1);
                this.firstError = false;
            }
        }
    }

    public void notifyNoError(boolean bl) {
        this.resetErrorIcon(false);
        EditixStatusBar.ACCESSOR.setError(null, false, null, null, 0);
        int n = EditixFrame.ACCESSOR.getMainTabbedPane().getSelectedIndex();
        if (bl) {
            this.getEditor().removeHighlightedErrorLine();
        }
    }

    public void stopErrorProcessing() {
    }

    public JPopupMenu getCurrentPopup() {
        if (EditixFrame.ACCESSOR != null) {
            return EditixFrame.ACCESSOR.getBuilder().getPopup("EDITOR");
        }
        return null;
    }

    public void showPopup(Component component, int n, int n2) {
        Serializable serializable;
        Serializable serializable2;
        EditixFrame.ACCESSOR.getBuilder().cleanMenuItems("findOccurences");
        SimpleNode simpleNode = this.getCurrentElementNode();
        if (simpleNode != null) {
            serializable2 = new DisplayOccurencesAction();
            ((AbstractAction)serializable2).putValue("Name", "The element " + simpleNode.getContent());
            ((AbstractAction)serializable2).putValue("param", "e" + simpleNode.getContent());
            serializable = EditixFrame.ACCESSOR.getBuilder().getMenu("findOccurences");
            ((JMenuItem)serializable).setEnabled(true);
            ((JMenu)serializable).add((Action)((Object)serializable2));
            if (simpleNode.getViewAttributeCount() > 0) {
                ((JMenu)serializable).addSeparator();
                for (int i = 0; i < simpleNode.getViewAttributeCount(); ++i) {
                    serializable2 = new DisplayOccurencesAction();
                    ((AbstractAction)serializable2).putValue("Name", "The attribute " + simpleNode.getViewAttributeAt(i));
                    ((AbstractAction)serializable2).putValue("param", "a" + simpleNode.getViewAttributeAt(i));
                    ((JMenu)serializable).add((Action)((Object)serializable2));
                }
            }
        }
        EditixFrame.ACCESSOR.getBuilder().cleanMenuItems("refactorRename");
        EditixFrame.ACCESSOR.getBuilder().cleanMenuItems("refactorDelete");
        EditixFrame.ACCESSOR.getBuilder().cleanMenuItems("refactorConvert");
        EditixFrame.ACCESSOR.getBuilder().cleanMenuItems("refactorSurround");
        EditixFrame.ACCESSOR.getBuilder().cleanMenuItems("refactorInsert");
        serializable2 = EditixFrame.ACCESSOR.getBuilder().getMenu("refactorRename");
        ((JMenuItem)serializable2).setEnabled(true);
        if (simpleNode != null) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            boolean bl = false;
            ArrayList arrayList = (ArrayList)this.getDocumentInfo().getProperty("refactor");
            if (arrayList != null) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    object6 = (AbstractRefactor)arrayList.get(i);
                    if (!((AbstractRefactor)object6).process(simpleNode)) continue;
                    bl = true;
                    object5 = new RefactorCustomAction((AbstractRefactor)object6);
                    ((AbstractAction)object5).putValue("Name", ((AbstractRefactor)object6).getTitle(simpleNode));
                    ((AbstractAction)object5).putValue("SmallIcon", this.getDocumentInfo().getDocumentIcon());
                    ((JMenu)serializable2).add((Action)object5);
                }
            }
            if (bl) {
                ((JMenu)serializable2).addSeparator();
            }
            RefactorRenameElementAction refactorRenameElementAction = new RefactorRenameElementAction();
            refactorRenameElementAction.putValue("Name", "The elements '" + simpleNode.getContent() + "'");
            ((JMenu)serializable2).add(refactorRenameElementAction);
            if (simpleNode.getNameSpacePrefix() != null) {
                object6 = new RefactorRenameElementPrefixAction();
                ((RefactorRenameElementPrefixAction)object6).setName(simpleNode.getNameSpacePrefix());
                ((AbstractAction)object6).putValue("Name", "The element prefix '" + simpleNode.getNameSpacePrefix() + "'");
                ((JMenu)serializable2).add((Action)object6);
            }
            if ((object6 = simpleNode.getNameSpaceDeclaration()) != null) {
                while (object6.hasMoreElements()) {
                    object5 = (String)object6.nextElement();
                    if (((String)object5).equals(simpleNode.getNameSpacePrefix())) continue;
                    object4 = new RefactorRenameElementPrefixAction();
                    ((RefactorRenameElementPrefixAction)object4).setName((String)object5);
                    ((AbstractAction)object4).putValue("Name", "The element prefix '" + (String)object5 + "'");
                    ((JMenu)serializable2).add((Action)object4);
                }
            }
            if (simpleNode.getNameSpaceURI() != null) {
                object5 = new RefactorRenameElementNamespaceAction();
                ((RefactorRenameElementNamespaceAction)object5).setOldValue(simpleNode.getNameSpaceURI());
                ((AbstractAction)object5).putValue("Name", "The element namespace URI '" + simpleNode.getNameSpaceURI() + "'");
                ((JMenu)serializable2).add((Action)object5);
            }
            if ((object5 = simpleNode.getNameSpaceDeclaration()) != null) {
                while (object5.hasMoreElements()) {
                    object4 = (String)object5.nextElement();
                    object3 = simpleNode.getNameSpaceDeclarationURI((String)object4);
                    if (((String)object3).equals(simpleNode.getNameSpaceURI())) continue;
                    object2 = new RefactorRenameElementNamespaceAction();
                    ((RefactorRenameElementNamespaceAction)object2).setOldValue((String)object3);
                    ((AbstractAction)object2).putValue("Name", "The namespace URI '" + (String)object3 + "'");
                    ((JMenu)serializable2).add((Action)object2);
                }
            }
            if (simpleNode.getViewAttributeCount() > 0) {
                int n3;
                ((JMenu)serializable2).addSeparator();
                for (n3 = 0; n3 < simpleNode.getViewAttributeCount(); ++n3) {
                    object3 = new RefactorRenameAttributeAction();
                    object2 = simpleNode.getViewAttributeAt(n3);
                    int n4 = ((String)object2).lastIndexOf(":");
                    if (n4 > -1) {
                        object2 = ((String)object2).substring(n4 + 1);
                    }
                    ((RefactorRenameAttributeAction)object3).setOldName((String)object2);
                    ((AbstractAction)object3).putValue("Name", "The attribute '" + (String)object2 + "'");
                    ((JMenu)serializable2).add((Action)object3);
                }
                ((JMenu)serializable2).addSeparator();
                for (n3 = 0; n3 < simpleNode.getViewAttributeCount(); ++n3) {
                    object3 = new RefactorRenameAttributeValueAction();
                    object2 = simpleNode.getViewAttributeAt(n3);
                    String string = simpleNode.getAttribute((String)object2);
                    ((RefactorRenameAttributeValueAction)object3).setOldValue(string);
                    ((AbstractAction)object3).putValue("Name", "The attribute value '" + string + "'");
                    ((JMenu)serializable2).add((Action)object3);
                }
            }
            serializable2 = EditixFrame.ACCESSOR.getBuilder().getMenu("refactorDelete");
            ((JMenuItem)serializable2).setEnabled(true);
            RefactorDeleteElementAction refactorDeleteElementAction = new RefactorDeleteElementAction();
            refactorDeleteElementAction.putValue("Name", "The elements '" + simpleNode.getContent() + "'");
            ((JMenu)serializable2).add(refactorDeleteElementAction);
            if (simpleNode.getNameSpaceURI() != null) {
                object3 = new RefactorDeleteElementInNamespaceAction();
                ((AbstractAction)object3).putValue("Name", "All the elements in the namespace '" + simpleNode.getNameSpaceURI() + "'");
                ((JMenu)serializable2).add((Action)object3);
            }
            if (simpleNode.getNameSpacePrefix() != null) {
                object3 = new RefactorDeletePrefixAction();
                ((RefactorDeletePrefixAction)object3).setPrefix(simpleNode.getNameSpacePrefix());
                ((AbstractAction)object3).putValue("Name", "The prefix '" + simpleNode.getNameSpacePrefix() + "'");
                ((JMenu)serializable2).add((Action)object3);
            }
            if ((object5 = simpleNode.getNameSpaceDeclaration()) != null) {
                while (object5.hasMoreElements()) {
                    object3 = (String)object5.nextElement();
                    if (((String)object3).equals(simpleNode.getNameSpacePrefix())) continue;
                    object2 = new RefactorDeletePrefixAction();
                    ((RefactorDeletePrefixAction)object2).setPrefix((String)object3);
                    ((AbstractAction)object2).putValue("Name", "The prefix '" + (String)object3 + "'");
                    ((JMenu)serializable2).add((Action)object2);
                }
            }
            if (simpleNode.getViewAttributeCount() > 0) {
                ((JMenu)serializable2).addSeparator();
                for (int i = 0; i < simpleNode.getViewAttributeCount(); ++i) {
                    object2 = new RefactorDeleteAttributeAction();
                    String string = simpleNode.getViewAttributeAt(i);
                    int n5 = string.lastIndexOf(":");
                    if (n5 > -1) {
                        string = string.substring(n5 + 1);
                    }
                    ((RefactorDeleteAttributeAction)object2).setName(string);
                    ((AbstractAction)object2).putValue("Name", "The attribute '" + string + "'");
                    ((JMenu)serializable2).add((Action)object2);
                }
            }
            RefactorDeleteTextAction refactorDeleteTextAction = new RefactorDeleteTextAction();
            refactorDeleteTextAction.putValue("Name", "Text inside the elements '" + simpleNode.getContent() + "'");
            ((JMenu)serializable2).add(refactorDeleteTextAction);
            serializable2 = EditixFrame.ACCESSOR.getBuilder().getMenu("refactorConvert");
            ((JMenuItem)serializable2).setEnabled(true);
            object2 = new RefactorConvertAttributesToElementAction();
            ((AbstractAction)object2).putValue("Name", "The attributes of the elements '" + simpleNode.getContent() + "' to elements");
            ((JMenu)serializable2).add((Action)object2);
            if (simpleNode.getViewAttributeCount() > 0) {
                ((JMenu)serializable2).addSeparator();
                for (int i = 0; i < simpleNode.getViewAttributeCount(); ++i) {
                    RefactorConvertAttributeToElementAction refactorConvertAttributeToElementAction = new RefactorConvertAttributeToElementAction();
                    object = simpleNode.getViewAttributeAt(i);
                    int n6 = ((String)object).lastIndexOf(":");
                    if (n6 > -1) {
                        object = ((String)object).substring(n6 + 1);
                    }
                    refactorConvertAttributeToElementAction.setName((String)object);
                    refactorConvertAttributeToElementAction.putValue("Name", "The attribute '" + (String)object + "' to element");
                    ((JMenu)serializable2).add(refactorConvertAttributeToElementAction);
                }
            }
            serializable2 = EditixFrame.ACCESSOR.getBuilder().getMenu("refactorSurround");
            ((JMenuItem)serializable2).setEnabled(true);
            RefactorSurroundElementAction refactorSurroundElementAction = new RefactorSurroundElementAction();
            refactorSurroundElementAction.putValue("Name", "The elements '" + simpleNode.getContent() + "'");
            ((JMenu)serializable2).add(refactorSurroundElementAction);
            serializable2 = EditixFrame.ACCESSOR.getBuilder().getMenu("refactorInsert");
            ((JMenuItem)serializable2).setEnabled(true);
            RefactorInsertElementAction refactorInsertElementAction = new RefactorInsertElementAction();
            refactorInsertElementAction.putValue("Name", "A new element inside the elements '" + simpleNode.getContent() + "'");
            ((JMenu)serializable2).add(refactorInsertElementAction);
            object = new RefactorInsertAttributeAction();
            ((AbstractAction)object).putValue("Name", "A new attribute inside the elements '" + simpleNode.getContent() + "'");
            ((JMenu)serializable2).add((Action)object);
            RefactorInsertTextAction refactorInsertTextAction = new RefactorInsertTextAction();
            refactorInsertTextAction.putValue("Name", "A text inside the elements '" + simpleNode.getContent() + "'");
            ((JMenu)serializable2).add(refactorInsertTextAction);
        }
        serializable2 = EditixFrame.ACCESSOR.getBuilder().getMenu("refactorDelete");
        ((JMenuItem)serializable2).setEnabled(true);
        serializable = new RefactorDeleteCommentsAction();
        ((AbstractAction)serializable).putValue("Name", "Delete all the comments (except before the root)");
        ((JMenu)serializable2).add((Action)((Object)serializable));
        super.showPopup(component, n, n2);
    }

    protected boolean useCustomPopupMenu() {
        return true;
    }

    public void caretLocation(int n, int n2) {
        EditixStatusBar.ACCESSOR.setLocation(n, n2);
    }

    public Object getProperty(String string) {
        if ("prefAPosEntity".equals(string)) {
            if ("XSLT".equals(this.getDocumentInfo().getType()) || "XSLT2".equals(this.getDocumentInfo().getType())) {
                return Boolean.FALSE;
            }
            return super.getProperty(string);
        }
        return super.getProperty(string);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        SimpleNode simpleNode;
        TreePath treePath;
        if (mouseEvent.getButton() != 1 && (treePath = this.getTree().getSelectionPath()) != null && (simpleNode = (SimpleNode)treePath.getLastPathComponent()) != null && simpleNode.isTag()) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.add(new CustomNodeLabel());
            jPopupMenu.show(this.getTree(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    static class IconErrorProxy
    implements Icon {
        private Icon source = null;
        private static Icon err = null;

        public IconErrorProxy(Icon icon) {
            this.source = icon;
            if (err == null) {
                URL uRL = ClassLoader.getSystemClassLoader().getResource("images/bug_mini.png");
                err = new ImageIcon(uRL);
            }
        }

        public Icon getSource() {
            return this.source;
        }

        public int getIconHeight() {
            return this.source.getIconHeight();
        }

        public int getIconWidth() {
            return this.source.getIconWidth();
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            this.source.paintIcon(component, graphics, n, n2);
            if (err != null) {
                err.paintIcon(component, graphics, n + 6, n2 + 6);
            }
        }
    }

    class CustomNodeLabel
    extends AbstractAction {
        public CustomNodeLabel() {
            this.putValue("Name", "Display this attribute");
            this.putValue("ShortDescription", "Choose an attribute name for the current node, it will be used for rendering the tree");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = EditixFactory.buildAndShowInputDialog("Choose your favorite attribute");
            if ("".equals(string)) {
                string = null;
            }
            FastTreeRenderer fastTreeRenderer = (FastTreeRenderer)EditixXMLContainer.this.getTree().getCellRenderer();
            SimpleNode simpleNode = (SimpleNode)EditixXMLContainer.this.getTree().getSelectionPath().getLastPathComponent();
            fastTreeRenderer.setAttribute(simpleNode.getNodeContent(), string);
            EditixXMLContainer.this.setProperty("tree.renderer.node." + simpleNode.getNodeContent(), string);
        }
    }
}

