/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.ui;

import com.japisoft.editix.ui.EditixErrorPanel;
import com.japisoft.editix.ui.EditixFrame;
import com.japisoft.editix.ui.FastLabel;
import com.japisoft.editix.ui.InformationDialog;
import com.japisoft.editix.ui.TableLayout;
import com.japisoft.framework.ApplicationModel;
import com.japisoft.framework.dockable.Windowable;
import com.japisoft.framework.dockable.action.ActionModel;
import com.japisoft.framework.job.JobManager;
import com.japisoft.framework.job.JobManagerListener;
import com.japisoft.framework.job.ShowHeavyJobAction;
import com.japisoft.framework.preferences.Preferences;
import com.japisoft.framework.ui.toolkit.Toolkit;
import com.japisoft.xmlpad.XMLContainer;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.Timer;

public class EditixStatusBar
extends JComponent
implements JobManagerListener,
MouseListener,
Windowable {
    public static EditixStatusBar ACCESSOR = null;
    private boolean capsLock = false;
    private boolean numLock = false;
    private FastLabel lblWorking;
    private FastLabel lbXPath;
    private FastLabel lbLocation;
    private FastLabel lbCaps;
    private FastLabel lbNum;
    private FastLabel lbError;
    private TableLayout layout = null;
    private Vector lastErrors = null;
    static ImageIcon ICON = null;
    InformationDialog dialog = null;

    public EditixStatusBar() {
        ACCESSOR = this;
        this.ui();
        try {
            this.capsLock = java.awt.Toolkit.getDefaultToolkit().getLockingKeyState(20);
            this.numLock = java.awt.Toolkit.getDefaultToolkit().getLockingKeyState(144);
        }
        catch (Throwable throwable) {
            System.out.println("Can't get CAPS/NUM state");
        }
        InputMap inputMap = this.getInputMap(2);
        ActionMap actionMap = this.getActionMap();
        actionMap.put("numLockAction", new ActionNumLock());
        actionMap.put("capsLockAction", new ActionCapsLock());
        inputMap.put(KeyStroke.getKeyStroke(20, 0), "capsLockAction");
        inputMap.put(KeyStroke.getKeyStroke(144, 0), "numLockAction");
        JobManager.setJobManagerListener(this);
    }

    private void resetCapsNum() {
        this.setCapsMode(this.capsLock);
        this.numLock = true;
        this.setNumMode(true);
    }

    public void addNotify() {
        super.addNotify();
        this.resetCapsNum();
        this.lbError.addMouseListener(this);
    }

    public void removeNotify() {
        super.removeNotify();
        this.lbError.removeMouseListener(this);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.lbError.setToolTipText(EditixErrorPanel.getErrorTooltip(0, this.lbError.getText()));
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    private void ui() {
        this.layout = new TableLayout(new double[][]{{0.02, 0.48, 0.3, 0.1, 0.05, 0.05}, {-1.0}});
        this.setLayout(this.layout);
        this.lblWorking = new FastLabel(true);
        this.add((Component)this.lblWorking, "0,0");
        this.lbXPath = new FastLabel(true);
        this.add((Component)this.lbXPath, "1,0");
        this.lbError = new FastLabel(true, false, true);
        this.add((Component)this.lbError, "2,0");
        this.lbLocation = new FastLabel(true, true);
        this.add((Component)this.lbLocation, "3,0");
        this.lbCaps = new FastLabel(true, false);
        this.add((Component)this.lbCaps, "4,0");
        this.lbNum = new FastLabel(true, false);
        this.add((Component)this.lbNum, "5,0");
        Font font = new Font("dialog", 0, 10);
        this.setFont(font);
        FontMetrics fontMetrics = this.getFontMetrics(font);
        this.setPreferredSize(new Dimension(0, fontMetrics.getHeight() + 10));
        this.lblWorking.setAction(ShowHeavyJobAction.getInstance());
        this.lbError.setAction(new ErrorAction());
    }

    public void fireDockEvent(String string, int n) {
    }

    public ActionModel getActionModel() {
        return null;
    }

    public JComponent getContentPane() {
        return null;
    }

    public Rectangle getFrameBounds() {
        return null;
    }

    public Icon getIcon() {
        return null;
    }

    public String getId() {
        return "statusbar";
    }

    public String getTitle() {
        return null;
    }

    public JComponent getUserView() {
        return null;
    }

    public JComponent getView() {
        return null;
    }

    public boolean isFixed() {
        return true;
    }

    public boolean isMaximized() {
        return false;
    }

    public boolean isResizable() {
        return false;
    }

    public void setContentPane(JComponent jComponent) {
    }

    public void setFixed(boolean bl) {
    }

    public void setFrameBounds(Rectangle rectangle) {
    }

    public void setIcon(Icon icon) {
    }

    public void setMaximized(boolean bl) {
    }

    public void setResizable(boolean bl) {
    }

    public void setTitle(String string) {
    }

    public void storeState(XMLContainer xMLContainer) {
        xMLContainer.setProperty("sb.xpath", this.lbXPath.getText());
        xMLContainer.setProperty("sb.loc", this.lbLocation.getText());
        xMLContainer.setProperty("sb.err", this.lbError.getText());
    }

    public void restoreState(XMLContainer xMLContainer) {
        Object object = xMLContainer.getProperty("sb.xpath");
        String string = object != null ? object.toString() : null;
        this.lbXPath.setText(string);
        object = xMLContainer.getProperty("sb.loc");
        string = object != null ? object.toString() : null;
        this.lbLocation.setText(string);
        object = xMLContainer.getProperty("sb.err");
        string = object != null ? object.toString() : null;
        this.lbError.setText(string);
    }

    public void clearState() {
        this.lbXPath.setText(null);
        this.lbLocation.setText(null);
        this.lbError.setText(null);
        this.lbError.setPopupMode(false);
        if (this.lastErrors != null) {
            this.lastErrors.removeAllElements();
        }
    }

    public void setXPathLocation(String string) {
        this.lbXPath.setText(string);
    }

    public void setMessage(String string) {
        this.lbXPath.setMessage(string);
        this.paintComponent(this.getGraphics());
    }

    public void setLocation(int n, int n2) {
        this.lbLocation.setText(n2 + ":" + n);
    }

    public void setDelayedMessage(String string) {
        DelayedMessage delayedMessage = new DelayedMessage(string);
        delayedMessage.start();
    }

    public void setCapsMode(boolean bl) {
        if (bl) {
            this.lbCaps.setText("Caps");
        } else {
            this.lbCaps.setText(null);
        }
    }

    public void setNumMode(boolean bl) {
        if (bl) {
            this.lbNum.setText("Num");
        } else {
            this.lbNum.setText(null);
        }
    }

    public void setError(Object object, boolean bl, String string, String string2, int n) {
        if (this.lastErrors == null) {
            this.lastErrors = new Vector();
        }
        if (string2 == null) {
            this.lastErrors.removeAllElements();
        }
        this.lbError.setPopupMode(string2 != null);
        this.lbError.error = string2 != null;
        String string3 = null;
        try {
            string3 = "onfly".equals(object) ? " (Press " + Toolkit.getKeyStrokeView((KeyStroke)EditixFrame.ACCESSOR.getBuilder().getActionById("parse").getValue("AcceleratorKey")) + " for more details)" : "";
        }
        catch (RuntimeException runtimeException) {
            ApplicationModel.debug(runtimeException);
            string3 = "";
        }
        if (string2 != null) {
            this.lbError.setText(string2 + string3);
        } else {
            this.lbError.setText(null);
        }
        if (string2 != null) {
            if (!this.lastErrors.contains(string2)) {
                this.lastErrors.add(string2);
                this.lastErrors.add(new Integer(n));
                this.lastErrors.add(new Boolean(bl));
                this.lastErrors.add(string);
                this.lbError.setErrorNumber("[" + this.lastErrors.size() / 4 + "]");
            }
            this.maximizedLblError();
        } else {
            this.restoredLblError();
        }
    }

    private void maximizedLblError() {
        this.layout.maximized(this.lbError);
        this.doLayout();
        this.repaint();
    }

    private void restoredLblError() {
        this.layout.maximized(null);
        this.doLayout();
        this.repaint();
    }

    public void startKnownJob(Object object, String string, boolean bl) {
        if (bl) {
            if (ICON == null) {
                ICON = new ImageIcon(ClassLoader.getSystemResource("images/gear.png"));
            }
            if (Preferences.getPreference("system", "taskdialog" + string, true)) {
                InformationDialog informationDialog = new InformationDialog(new JLabel("This task will work in background : '" + string + "'", ICON, 2), "taskdialog" + string);
                ((Dialog)informationDialog).setVisible(true);
                informationDialog.dispose();
            }
            this.lbError.error = false;
            this.lblWorking.setIcon(ICON);
        }
        if (!this.lbError.error) {
            this.lbError.setMessage("Preparing '" + string + "'");
        }
    }

    public void stopKnownJob(String string, String string2, boolean bl) {
        if (this.dialog != null) {
            this.dialog.setVisible(false);
            this.dialog = null;
        }
        if (!this.lbError.error && this.lbError.text != null) {
            this.lbError.error = false;
            this.lbError.setMessage("Done");
        }
        if (bl) {
            this.lblWorking.setIcon(null);
            if (string2 == null) {
                if (Preferences.getPreference("interface", "beepForActionEnd", true)) {
                    try {
                        java.awt.Toolkit.getDefaultToolkit().beep();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                JOptionPane.showMessageDialog(EditixFrame.ACCESSOR, "Operation '" + string + "' completed");
            }
        }
    }

    private void showErrorPopups() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        for (int i = 0; i < this.lastErrors.size(); i += 4) {
            String string = (String)this.lastErrors.get(i);
            Integer n = (Integer)this.lastErrors.get(i + 1);
            boolean bl = (Boolean)this.lastErrors.get(i + 2);
            String string2 = (String)this.lastErrors.get(i + 3);
            jPopupMenu.add(new ErrorPopupItemAction(string, n, bl, string2));
        }
        jPopupMenu.show(this.lbError, 10, -((int)jPopupMenu.getPreferredSize().getHeight()));
    }

    class DelayedMessage
    extends Timer
    implements ActionListener {
        private String savedMessage;

        public DelayedMessage(String string) {
            super(2000, null);
            this.setRepeats(false);
            this.savedMessage = EditixStatusBar.this.lbXPath.getText();
            EditixStatusBar.this.lbXPath.setMessageMode(true);
            EditixStatusBar.this.lbXPath.setText(string);
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EditixStatusBar.this.lbXPath.setMessageMode(false);
            EditixStatusBar.this.lbXPath.setText(this.savedMessage);
            this.removeActionListener(this);
        }
    }

    class ErrorPopupItemAction
    extends AbstractAction {
        int line;
        String error;
        boolean local;
        String sourceLocation;

        public ErrorPopupItemAction(String string, int n, boolean bl, String string2) {
            this.error = string;
            this.line = n;
            this.putValue("Name", string);
            this.putValue("ShortDescription", string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EditixFrame.ACCESSOR.displaySelectedError(this.local, this.sourceLocation, this.error, this.line);
        }
    }

    class ErrorAction
    extends AbstractAction {
        ErrorAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (EditixStatusBar.this.lastErrors != null && EditixStatusBar.this.lastErrors.size() > 0) {
                EditixStatusBar.this.showErrorPopups();
            }
        }
    }

    class ActionCapsLock
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditixStatusBar.this.setCapsMode(EditixStatusBar.this.capsLock = !EditixStatusBar.this.capsLock);
        }
    }

    class ActionNumLock
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditixStatusBar.this.setNumMode(EditixStatusBar.this.numLock = !EditixStatusBar.this.numLock);
        }
    }
}

