/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.action.xml;

import com.japisoft.fastparser.node.SimpleNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class NamespacePanel
extends JPanel {
    private DefaultTableModel model;
    private SimpleNode currentNode;
    private JTable table;
    private ArrayList namespaces = null;
    private CustomTableRenderer renderer = new CustomTableRenderer();
    private CustomTableEditor editor = new CustomTableEditor();

    public NamespacePanel(SimpleNode simpleNode) {
        this.currentNode = simpleNode;
        this.initUI();
        this.initNamespaces();
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.table.getCellEditor() != null) {
            this.table.getCellEditor().stopCellEditing();
        }
    }

    public void updateNode() {
        this.currentNode.removeAllNameSpaceDeclaration();
        this.currentNode.setNameSpace(null, null);
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            Boolean bl = (Boolean)this.model.getValueAt(i, 2);
            String string = (String)this.model.getValueAt(i, 0);
            String string2 = (String)this.model.getValueAt(i, 1);
            if (string2 == null) {
                string2 = "";
            }
            if (bl.booleanValue()) {
                if (string != null && !"".equals(string)) {
                    this.currentNode.setNameSpace(string, string2);
                    if (this.namespaces.indexOf(string) != -1) continue;
                    this.currentNode.addNameSpaceDeclaration(string, string2);
                    continue;
                }
                if ("".equals(string2)) continue;
                this.currentNode.setDefaultNamespace(string2);
                continue;
            }
            if (string == null || "".equals(string)) {
                this.currentNode.setDefaultNamespace(null);
            }
            if (this.namespaces.indexOf(string2) != -1 || string == null || "".equals(string)) continue;
            this.currentNode.addNameSpaceDeclaration(string, string2);
        }
    }

    private void initNamespaces() {
        String string;
        String string2;
        Enumeration enumeration;
        SimpleNode simpleNode;
        this.namespaces = new ArrayList();
        for (simpleNode = this.currentNode; simpleNode != null; simpleNode = simpleNode.getSimpleParent()) {
            enumeration = simpleNode.getNameSpaceDeclaration();
            if (enumeration == null) continue;
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                string = simpleNode.getNameSpaceDeclarationURI(string2);
                if (simpleNode != this.currentNode) {
                    this.namespaces.add(string2);
                    this.namespaces.add(string);
                }
                this.editor.namespace.addItem(string);
            }
        }
        simpleNode = this.currentNode;
        enumeration = simpleNode.getNameSpaceDeclaration();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                string = simpleNode.getNameSpaceDeclarationURI(string2);
                this.model.addRow(new Object[]{string2, string, new Boolean(string2.equals(simpleNode.getNameSpacePrefix()))});
            }
        }
        if (simpleNode.getDefaultNamespace() != null) {
            this.model.addRow(new Object[]{null, simpleNode.getDefaultNamespace(), new Boolean(simpleNode.getNameSpacePrefix() == null)});
        }
        if (simpleNode.getNameSpacePrefix() != null && !simpleNode.isNamespaceDeclared(simpleNode.getNameSpacePrefix())) {
            int n = this.namespaces.indexOf(simpleNode.getNameSpacePrefix());
            if (n > -1) {
                string = (String)this.namespaces.get(n + 1);
                this.model.addRow(new Object[]{simpleNode.getNameSpacePrefix(), string, Boolean.TRUE});
            } else {
                this.model.addRow(new Object[]{simpleNode.getNameSpacePrefix(), "", Boolean.TRUE});
            }
        }
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
        this.table = new JTable(){

            public TableCellRenderer getDefaultRenderer(Class clazz) {
                return NamespacePanel.this.renderer;
            }

            public TableCellEditor getDefaultEditor(Class clazz) {
                return NamespacePanel.this.editor;
            }
        };
        this.table.setSelectionMode(0);
        this.table.setColumnSelectionAllowed(false);
        this.model = new DefaultTableModel(new String[]{"Prefix", "Namespace", "Current"}, 0);
        this.table.setModel(this.model);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(50);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.add((Component)new JScrollPane(this.table), "Center");
        JToolBar jToolBar = new JToolBar();
        this.add((Component)jToolBar, "North");
        jToolBar.add(new AddAction());
        jToolBar.add(new RemoveAction());
    }

    class CustomTableEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private JTextField prefix = new JTextField();
        JComboBox namespace = new JComboBox();
        private JCheckBox current = new JCheckBox();
        private int lastCol = -1;
        private int lastRow = -1;

        CustomTableEditor() {
            this.current.addActionListener(this);
            this.namespace.setEditable(true);
            this.namespace.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.lastRow == -1) {
                return;
            }
            if (actionEvent.getSource() == this.current) {
                if (this.current.isSelected()) {
                    for (int i = 0; i < NamespacePanel.this.model.getRowCount(); ++i) {
                        Boolean bl;
                        if (i == this.lastRow || !(bl = (Boolean)NamespacePanel.this.model.getValueAt(i, 2)).booleanValue()) continue;
                        NamespacePanel.this.model.setValueAt(Boolean.FALSE, i, 2);
                    }
                    NamespacePanel.this.model.setValueAt(Boolean.TRUE, this.lastRow, 2);
                } else {
                    NamespacePanel.this.model.setValueAt(Boolean.FALSE, this.lastRow, 2);
                }
            } else if (actionEvent.getSource() == this.namespace) {
                String string = (String)this.namespace.getSelectedItem();
                int n = NamespacePanel.this.namespaces.indexOf(string);
                if (n >= 1) {
                    String string2 = (String)NamespacePanel.this.namespaces.get(n - 1);
                    NamespacePanel.this.model.setValueAt(string2, this.lastRow, 0);
                }
                NamespacePanel.this.model.setValueAt(string, this.lastRow, 1);
            }
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.lastCol = n2;
            this.lastRow = n;
            if (object == null) {
                object = "";
            }
            switch (n2) {
                case 0: {
                    this.prefix.setText(object.toString());
                    return this.prefix;
                }
                case 1: {
                    this.namespace.getEditor().setItem(object);
                    return this.namespace;
                }
                case 2: {
                    this.current.setSelected((Boolean)object);
                    return this.current;
                }
            }
            return null;
        }

        public Object getCellEditorValue() {
            switch (this.lastCol) {
                case 0: {
                    return this.prefix.getText();
                }
                case 1: {
                    Object object = this.namespace.getEditor().getItem();
                    return object;
                }
                case 2: {
                    return new Boolean(this.current.isSelected());
                }
            }
            return null;
        }
    }

    class CustomTableRenderer
    implements TableCellRenderer {
        private JLabel prefix = new JLabel();
        private JComboBox namespace = new JComboBox();
        private JCheckBox current = new JCheckBox();

        CustomTableRenderer() {
            this.prefix.setOpaque(true);
            this.namespace.setEditable(true);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.prefix.setBackground(jTable.getSelectionBackground());
                this.prefix.setForeground(jTable.getSelectionForeground());
                this.current.setBackground(jTable.getSelectionBackground());
                this.current.setForeground(jTable.getSelectionForeground());
            } else {
                this.prefix.setBackground(jTable.getBackground());
                this.prefix.setForeground(jTable.getForeground());
                this.current.setBackground(jTable.getBackground());
                this.current.setForeground(jTable.getForeground());
            }
            if (object != null) {
                switch (n2) {
                    case 0: {
                        this.prefix.setText(object.toString());
                        return this.prefix;
                    }
                    case 1: {
                        this.namespace.setSelectedItem(object.toString());
                        return this.namespace;
                    }
                    case 2: {
                        this.current.setSelected((Boolean)object);
                        return this.current;
                    }
                }
            }
            return null;
        }
    }

    class RemoveAction
    extends AbstractAction {
        RemoveAction() {
            this.putValue("ShortDescription", "Remove a namespace definition");
            this.putValue("Name", "Remove a namespace definition");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = NamespacePanel.this.table.getSelectedRow();
            if (n >= 0) {
                NamespacePanel.this.table.getCellEditor().stopCellEditing();
                NamespacePanel.this.model.removeRow(n);
            }
        }
    }

    class AddAction
    extends AbstractAction {
        AddAction() {
            this.putValue("ShortDescription", "Add a new namespace definition");
            this.putValue("Name", "Add a namespace definition");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NamespacePanel.this.model.addRow(new Object[]{"", "", Boolean.FALSE});
        }
    }
}

