/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.action.dtdschema.generator.transformer;

import com.japisoft.editix.action.dtdschema.generator.MetaAttribute;
import com.japisoft.editix.action.dtdschema.generator.MetaNode;
import com.japisoft.editix.action.dtdschema.generator.Transformer;
import com.japisoft.framework.preferences.Preferences;
import java.util.ArrayList;
import java.util.Vector;

public class SchemaTransformer
implements Transformer {
    private String schemaPrefix = Preferences.getPreference("xmlconfig", "W3C XML Schema prefix", "xs");

    public String getType() {
        return "XSD";
    }

    public String transform(MetaNode metaNode, ArrayList arrayList) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<").append(this.schemaPrefix).append(":schema xmlns:").append(this.schemaPrefix).append("=\"http://www.w3.org/2001/XMLSchema\" elementFormDefault=\"qualified\"");
        if (metaNode.getNamespace() != null) {
            stringBuffer.append(" targetNamespace=\"" + metaNode.getNamespace() + "\" xmlns:editix=\"" + metaNode.getNamespace() + "\"");
        }
        stringBuffer.append(">");
        stringBuffer.append(System.getProperty("line.separator"));
        for (int i = 0; i < arrayList.size(); ++i) {
            this.generateSchema(metaNode.getNamespace() != null, (MetaNode)arrayList.get(i), arrayList, stringBuffer);
        }
        stringBuffer.append("</").append(this.schemaPrefix).append(":schema>");
        return stringBuffer.toString();
    }

    public boolean hasVersion() {
        return true;
    }

    private boolean hasTextNode(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            MetaNode metaNode = (MetaNode)vector.get(i);
            if (!metaNode.acceptText()) continue;
            return true;
        }
        return false;
    }

    private void generateSchema(boolean bl, MetaNode metaNode, ArrayList arrayList, StringBuffer stringBuffer) {
        boolean bl2;
        boolean bl3;
        boolean bl4 = this.hasTextNode(metaNode.getChildren());
        stringBuffer.append("\n");
        if (metaNode.getChildren().size() == 0 && !metaNode.hasAttributes() && metaNode.acceptText()) {
            stringBuffer.append("  <").append(this.schemaPrefix).append(":element name=\"").append(metaNode.getName()).append("\" type=\"").append(this.schemaPrefix).append(":string\"/>");
            stringBuffer.append(System.getProperty("line.separator"));
            return;
        }
        stringBuffer.append("  <").append(this.schemaPrefix).append(":element name=\"").append(metaNode.getName()).append("\">").append(System.getProperty("line.separator"));
        boolean bl5 = metaNode.getChildren().size() >= 1 || metaNode.getChildren().size() == 0 && !metaNode.acceptText();
        boolean bl6 = bl3 = !bl5 && metaNode.hasAttributes();
        if (bl5) {
            stringBuffer.append("    <").append(this.schemaPrefix).append(":complexType");
            if (bl4) {
                stringBuffer.append(" mixed=\"true\">");
            } else {
                stringBuffer.append(">");
            }
            stringBuffer.append(System.getProperty("line.separator"));
        } else if (bl3) {
            stringBuffer.append("    <").append(this.schemaPrefix).append(":complexType>");
            stringBuffer.append(System.getProperty("line.separator"));
            stringBuffer.append("     <").append(this.schemaPrefix).append(":simpleContent>");
            stringBuffer.append(System.getProperty("line.separator"));
            stringBuffer.append("       <").append(this.schemaPrefix).append(":extension base=\"").append(this.schemaPrefix).append(":").append("string\">");
            stringBuffer.append(System.getProperty("line.separator"));
        }
        boolean bl7 = bl2 = metaNode.getChildren().size() == 1 && !metaNode.hasMultipleOccurence((MetaNode)metaNode.getChildren().get(0));
        if (bl2) {
            stringBuffer.append("      <").append(this.schemaPrefix).append(":sequence>");
        } else if (metaNode.getChildren().size() >= 1) {
            stringBuffer.append("      <").append(this.schemaPrefix).append(":choice minOccurs=\"0\" maxOccurs=\"unbounded\">");
        }
        if (metaNode.getChildren().size() > 0) {
            stringBuffer.append(System.getProperty("line.separator"));
        }
        for (int i = 0; i < metaNode.getChildren().size(); ++i) {
            MetaNode metaNode2 = (MetaNode)metaNode.getChildren().get(i);
            stringBuffer.append("        ").append("<").append(this.schemaPrefix).append(":element ref=\"").append(bl ? "editix:" : "").append(metaNode2.getName()).append("\"/>");
            stringBuffer.append(System.getProperty("line.separator"));
        }
        if (bl2) {
            stringBuffer.append("      </").append(this.schemaPrefix).append(":sequence>");
            stringBuffer.append(System.getProperty("line.separator"));
        } else if (metaNode.getChildren().size() >= 1) {
            stringBuffer.append("      </").append(this.schemaPrefix).append(":choice>");
            stringBuffer.append(System.getProperty("line.separator"));
        }
        if (metaNode.hasAttributes()) {
            Vector vector = metaNode.getAttributes();
            for (int i = 0; i < vector.size(); ++i) {
                MetaAttribute metaAttribute = (MetaAttribute)vector.get(i);
                stringBuffer.append("      <").append(this.schemaPrefix).append(":attribute name=\"").append(metaAttribute.name).append("\"");
                stringBuffer.append(" type=\"");
                stringBuffer.append(this.schemaPrefix).append(":");
                stringBuffer.append(SchemaTransformer.translateType(metaAttribute.getType()));
                stringBuffer.append("\"");
                if (metaAttribute.isAlways()) {
                    stringBuffer.append(" use=\"required\"");
                }
                stringBuffer.append("/>").append(System.getProperty("line.separator"));
            }
        }
        if (bl5) {
            stringBuffer.append("    </").append(this.schemaPrefix).append(":complexType>");
        } else if (bl3) {
            stringBuffer.append("       </").append(this.schemaPrefix).append(":extension>");
            stringBuffer.append(System.getProperty("line.separator"));
            stringBuffer.append("     </").append(this.schemaPrefix).append(":simpleContent>");
            stringBuffer.append(System.getProperty("line.separator"));
            stringBuffer.append("    </").append(this.schemaPrefix).append(":complexType>");
        }
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("  </").append(this.schemaPrefix).append(":element>");
        stringBuffer.append(System.getProperty("line.separator"));
    }

    static String translateType(String string) {
        String string2 = "string";
        if ("BOOLEAN".equals(string)) {
            string2 = "boolean";
        } else if ("DATE".equals(string)) {
            string2 = "date";
        } else if ("DECIMAL".equals(string)) {
            string2 = "decimal";
        } else if ("DOUBLE".equals(string)) {
            string2 = "double";
        } else if ("ID".equals(string)) {
            string2 = "ID";
        } else if ("IDREF".equals(string)) {
            string2 = "IDREF";
        } else if ("TIME".equals(string)) {
            string2 = "time";
        } else if ("URI".equals(string)) {
            string2 = "anyURI";
        }
        return string2;
    }
}

