/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.cdlib.xtf.util.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubDirFilter {
    private HashSet<String> targets = new HashSet();
    private HashSet<String> ancestors = new HashSet();

    public boolean isEmpty() {
        return this.targets.isEmpty();
    }

    public void add(File dirFile) {
        this.targets.add(dirFile.toString());
        for (String a : this.ancestorOrSelf(dirFile)) {
            if (!this.ancestors.add(a)) break;
        }
    }

    public int size() {
        return this.targets.size();
    }

    public List<String> getTargets() {
        ArrayList<String> list = new ArrayList<String>(this.targets);
        Collections.sort(list);
        return list;
    }

    public boolean approve(String dir) {
        return this.approve(new File(Path.normalizePath(dir)));
    }

    public boolean approve(File dirFile) {
        if (this.ancestors.contains(dirFile.toString())) {
            return true;
        }
        for (String a : this.ancestorOrSelf(dirFile)) {
            if (!this.targets.contains(a)) continue;
            return true;
        }
        return false;
    }

    private ArrayList<String> ancestorOrSelf(File dir) {
        ArrayList<String> list = new ArrayList<String>();
        boolean found = false;
        while (!found && dir != null) {
            list.add(dir.toString());
            dir = dir.getParentFile();
        }
        return list;
    }
}

