/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.util;

import java.io.IOException;
import java.io.OutputStream;

class LimitedOutputStream
extends OutputStream {
    private OutputStream realOut;
    private int total = 0;
    private int limit;

    public LimitedOutputStream(OutputStream realOut, int limit) {
        this.realOut = realOut;
        this.limit = limit;
    }

    public void close() throws IOException {
        this.realOut.close();
    }

    public void flush() throws IOException {
        this.realOut.flush();
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        int max = this.limit - this.total;
        if (max > 0) {
            if (max > len) {
                max = len;
            }
            this.realOut.write(b, off, max);
            this.total += max;
        }
    }

    public void write(int b) throws IOException {
        if (this.total < this.limit) {
            this.realOut.write(b);
            ++this.total;
        }
    }
}

