/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.util;

import org.cdlib.xtf.util.IntHash;
import org.cdlib.xtf.util.Tester;

public class FastIntCache {
    private int size;
    private IntHash oldHash;
    private IntHash newHash;
    public static final Tester tester = new Tester("FastIntCache"){

        protected void testImpl() {
            IntHash.tester.test();
            FastIntCache cache = new FastIntCache(3);
            cache.put(1, "a");
            cache.put(2, "b");
            cache.put(3, "c");
            if (!$assertionsDisabled && !cache.contains(1)) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !cache.contains(2)) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !cache.contains(3)) {
                throw new AssertionError();
            }
            cache.put(4, "d");
            if (!$assertionsDisabled && !cache.get(2).equals("b")) {
                throw new AssertionError();
            }
            cache.put(5, "e");
            cache.put(6, "f");
            if (!$assertionsDisabled && cache.contains(1)) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !cache.contains(2)) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !cache.contains(5)) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !cache.contains(6)) {
                throw new AssertionError();
            }
        }
    };

    public FastIntCache(int size) {
        this.size = size;
        this.clear();
    }

    public void clear() {
        this.oldHash = new IntHash(1);
        this.newHash = new IntHash(this.size);
    }

    public boolean contains(int key) {
        return this.newHash.contains(key) || this.oldHash.contains(key);
    }

    public Object get(int key) {
        Object retVal = this.newHash.get(key);
        if (retVal == null && (retVal = this.oldHash.get(key)) != null) {
            this.put(key, retVal);
        }
        return retVal;
    }

    public void put(int key, Object val) {
        if (this.newHash.size() >= this.size) {
            this.oldHash = this.newHash;
            this.newHash = new IntHash(this.size);
        }
        this.newHash.put(key, val);
    }
}

