/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import org.cdlib.xtf.util.FastCache;
import org.cdlib.xtf.util.IntHash;
import org.cdlib.xtf.util.Trace;

public class CharMap {
    private char[] map = new char[65536];
    private static final char NULL_CHAR = '\uee00';
    private static final int SUPP_HASH_SIZE = 100;
    private IntHash supplementalCharsMap = new IntHash(100);
    private static final int CACHE_SIZE = 5000;
    private FastCache cache = new FastCache(5000);

    public CharMap(File f) throws IOException {
        this.readFile(new BufferedReader(new FileReader(f)));
    }

    public CharMap(InputStream s) throws IOException {
        this.readFile(new BufferedReader(new InputStreamReader(s)));
    }

    public synchronized String mapWord(String word) {
        String val = null;
        if (this.cache.contains(word)) {
            val = (String)this.cache.get(word);
            return val;
        }
        int i = 0;
        while (i < word.length()) {
            if (this.map[word.charAt(i)] != '\u0000') break;
            ++i;
        }
        if (i == word.length()) {
            this.cache.put(word, null);
            return null;
        }
        StringBuffer buf = new StringBuffer(word.length() + 2);
        buf.append(word);
        i = 0;
        int nIterations = 0;
        while (i < buf.length()) {
            char c = buf.charAt(i);
            if (++nIterations > 100000) {
                throw new RuntimeException("Probable infinite loop detected in word map");
            }
            if (this.map[c] == '\u0000') {
                ++i;
                continue;
            }
            if (this.map[c] == '\uee00') {
                buf.deleteCharAt(i);
                continue;
            }
            buf.setCharAt(i, this.map[c]);
            String suppChars = (String)this.supplementalCharsMap.get(c);
            if (suppChars == null) continue;
            buf.insert(i + 1, suppChars);
        }
        String newWord = buf.toString();
        this.cache.put(word, newWord);
        return newWord;
    }

    private void readFile(BufferedReader reader) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            int barPos;
            if (line.indexOf("//") >= 0) {
                line = line.substring(0, line.indexOf("//"));
            }
            if (line.indexOf("#") >= 0) {
                line = line.substring(0, line.indexOf("#"));
            }
            if (line.indexOf(";") >= 0) {
                line = line.substring(0, line.indexOf(";"));
            }
            if ((barPos = line.indexOf(124)) < 0) continue;
            String key = line.substring(0, barPos).trim();
            String val = line.substring(barPos + 1).trim();
            int keyCode = -1;
            try {
                keyCode = Integer.parseInt(key, 16);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (keyCode < 0 || keyCode > 65535 || key.length() != 4) {
                Trace.warning("Warning: Invalid key in char mapping: key '" + key + "' must be exactly four hex digits");
                continue;
            }
            StringTokenizer st = new StringTokenizer(val);
            StringBuffer valBuf = new StringBuffer(3);
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                int valCode = -1;
                try {
                    valCode = Integer.parseInt(tok, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (valCode < 0 || valCode > 65535) {
                    Trace.warning("Warning: Invalid key/val char mapping: '" + key + "' -> '" + val + "' (value must be series of 4-digit hex numbers)");
                    continue;
                }
                valBuf.append((char)valCode);
            }
            if (valBuf.length() == 0) {
                this.map[keyCode] = 60928;
                continue;
            }
            this.map[keyCode] = valBuf.charAt(0);
            if (valBuf.length() <= 1) continue;
            this.supplementalCharsMap.put(keyCode, valBuf.substring(1));
        }
    }
}

