/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textIndexer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.transform.Templates;
import org.cdlib.xtf.textEngine.IndexUtil;
import org.cdlib.xtf.textIndexer.IndexRecord;
import org.cdlib.xtf.textIndexer.IndexSource;
import org.cdlib.xtf.util.Normalizer;
import org.cdlib.xtf.util.Path;
import org.cdlib.xtf.util.StructuredStore;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLIndexSource
extends IndexSource {
    private InputSource inSrc;
    private File path;
    private String key;
    private Templates[] preFilters;
    private Templates displayStyle;
    private StructuredStore lazyStore;
    private boolean removeDoctypeDecl = false;
    private boolean isDone = false;
    private static SAXParser saxParser = IndexUtil.createSAXParser();

    public XMLIndexSource(InputSource inSrc, String key) {
        String sysId = inSrc.getSystemId();
        this.inSrc = inSrc;
        this.path = sysId == null ? null : new File(sysId);
        this.key = key;
        this.preFilters = null;
        this.displayStyle = null;
        this.lazyStore = null;
    }

    public XMLIndexSource(InputSource inSrc, File path, String key, Templates[] preFilters, Templates displayStyle, StructuredStore lazyStore) {
        this.inSrc = inSrc;
        this.path = path;
        this.key = key;
        this.preFilters = preFilters;
        this.displayStyle = displayStyle;
        this.lazyStore = lazyStore;
    }

    public void removeDoctypeDecl(boolean flag) {
        this.removeDoctypeDecl = flag;
    }

    public File path() {
        return this.path;
    }

    public String key() {
        return this.key;
    }

    public Templates[] preFilters() {
        return this.preFilters;
    }

    public Templates displayStyle() {
        return this.displayStyle;
    }

    public long totalSize() {
        if (this.path == null) {
            return 1L;
        }
        return this.path.length();
    }

    public IndexRecord nextRecord() throws SAXException, IOException {
        if (this.isDone) {
            return null;
        }
        try {
            IndexRecord indexRecord = new IndexRecord(){

                public InputSource xmlSource() throws IOException {
                    return XMLIndexSource.this.filterInput();
                }

                public int recordNum() {
                    return 0;
                }

                public int percentDone() {
                    return 100;
                }

                public StructuredStore lazyStore() {
                    return XMLIndexSource.this.lazyStore;
                }
            };
            return indexRecord;
        }
        finally {
            this.isDone = true;
        }
    }

    protected InputSource filterInput() throws IOException {
        InputStream inStream;
        if (this.inSrc.getCharacterStream() != null) {
            return this.inSrc;
        }
        boolean applyCrimsonWorkaround = saxParser.getClass().getName().equals("org.apache.crimson.jaxp.SAXParserImpl");
        if (!applyCrimsonWorkaround && !this.removeDoctypeDecl) {
            return this.inSrc;
        }
        if (this.inSrc.getByteStream() != null) {
            inStream = this.inSrc.getByteStream();
        } else if (this.inSrc.getSystemId() != null && this.inSrc.getSystemId().length() > 0) {
            String path = Path.normalizeFileName(this.inSrc.getSystemId());
            if (path.startsWith("file://")) {
                path = path.substring(6);
            } else if (path.startsWith("file:/")) {
                path = path.substring(5);
            }
            if (!new File(path).canRead()) {
                throw new FileNotFoundException(this.inSrc.getSystemId());
            }
            inStream = new FileInputStream(path);
        } else {
            throw new IOException("Must pass a Reader, InputStream or system ID to index");
        }
        inStream = IndexUtil.filterXMLDocument(inStream, applyCrimsonWorkaround, this.removeDoctypeDecl);
        InputSource finalSrc = new InputSource(inStream);
        if (this.inSrc.getSystemId() != null) {
            finalSrc.setSystemId(this.inSrc.getSystemId());
        }
        return finalSrc;
    }

    public static String normalize(String s) {
        String s2;
        char[] ch = s.toCharArray();
        boolean needNormalize = false;
        int needEscape = 0;
        int i = 0;
        while (i < ch.length) {
            if ((ch[i] & 0xFFFFFF80) != 0) {
                needNormalize = true;
            }
            if (ch[i] == '&' || ch[i] == '<') {
                ++needEscape;
            } else if (ch[i] < ' ' && ch[i] != '\t' && ch[i] != '\n' && ch[i] != '\r') {
                ++needEscape;
            } else if (ch[i] >= '\ud800' && ch[i] <= '\udfff') {
                ++needEscape;
            } else if (ch[i] >= '\ufffe' && ch[i] <= '\uffff') {
                ++needEscape;
            }
            ++i;
        }
        if (needNormalize && !s.equals(s2 = Normalizer.normalize(s))) {
            s = s2;
            ch = s2.toCharArray();
        }
        if (needEscape > 0) {
            int maxSpace = ch.length + needEscape * 5;
            char[] newCh = new char[maxSpace];
            int dp = 0;
            int sp = 0;
            while (sp < ch.length) {
                if (ch[sp] == '&') {
                    newCh[dp++] = 38;
                    newCh[dp++] = 97;
                    newCh[dp++] = 109;
                    newCh[dp++] = 112;
                    newCh[dp++] = 59;
                } else if (ch[sp] == '<') {
                    newCh[dp++] = 38;
                    newCh[dp++] = 108;
                    newCh[dp++] = 116;
                    newCh[dp++] = 59;
                } else if (!(ch[sp] < ' ' && ch[sp] != '\t' && ch[sp] != '\n' && ch[sp] != '\r' || ch[sp] >= '\ud800' && ch[sp] <= '\udfff' || ch[sp] >= '\ufffe' && ch[sp] <= '\uffff')) {
                    newCh[dp++] = ch[sp];
                }
                ++sp;
            }
            s = new String(newCh, 0, dp);
        }
        return s;
    }
}

