/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textIndexer;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Vector;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.cdlib.xtf.textEngine.NativeFSDirectory;
import org.cdlib.xtf.textIndexer.IndexInfo;
import org.cdlib.xtf.textIndexer.IndexerConfig;
import org.cdlib.xtf.textIndexer.XMLConfigParser;
import org.cdlib.xtf.util.Path;
import org.cdlib.xtf.util.Trace;

public class IndexMerge {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) {
        Trace.info("IndexMerge v. 3.1");
        try {
            IndexerConfig cfgInfo = new IndexerConfig();
            XMLConfigParser cfgParser = new XMLConfigParser();
            int startArg = 0;
            boolean showUsage = false;
            cfgInfo.xtfHomePath = System.getProperty("xtf.home");
            if (cfgInfo.xtfHomePath == null || cfgInfo.xtfHomePath.length() == 0) {
                Trace.error("Error: xtf.home property not found");
                return;
            }
            cfgInfo.xtfHomePath = Path.normalizePath(cfgInfo.xtfHomePath);
            if (!new File(cfgInfo.xtfHomePath).isDirectory()) {
                Trace.error("Error: xtf.home directory \"" + cfgInfo.xtfHomePath + "\" does not exist or cannot be read.");
                return;
            }
            Vector<String> mergePaths = new Vector<String>();
            HashSet<String> pathSet = new HashSet<String>();
            while (!showUsage && startArg < args.length) {
                if (args.length < 4) {
                    showUsage = true;
                    continue;
                }
                int ret = cfgInfo.readCmdLine(args, startArg);
                if (ret == -1) {
                    if (startArg != 0) break;
                    showUsage = true;
                } else {
                    if (!new File(cfgInfo.cfgFilePath).isAbsolute()) {
                        cfgInfo.cfgFilePath = Path.resolveRelOrAbs(cfgInfo.xtfHomePath, cfgInfo.cfgFilePath);
                    }
                    if (cfgParser.configure(cfgInfo) < 0) {
                        Trace.error("Error: index '" + cfgInfo.indexInfo.indexName + "' not found\n");
                        System.exit(1);
                    }
                }
                startArg = ret;
                IndexInfo idxInfo = cfgInfo.indexInfo;
                String idxPath = Path.resolveRelOrAbs(cfgInfo.xtfHomePath, idxInfo.indexPath);
                if (pathSet.contains(idxPath)) {
                    Trace.error("Error: indexes to be merged must be in separate directories.");
                    System.exit(1);
                }
                pathSet.add(idxPath);
                mergePaths.add(idxPath);
            }
            if (mergePaths.size() < 2) {
                showUsage = true;
            }
            if (showUsage) {
                Trace.error("  usage: ");
                Trace.tab();
                Trace.error("indexMerge -config <config1> -index <index1> -config <config2> -index <inputIndex2> ...\n\nSample use:\n1. Make two config files, each with different input and output directories.\n2. textIndexer -config conf/textIndexer.conf1 -clean -noupdatespell -index default\n3. textIndexer -config conf/textIndexer.conf2 -clean -noupdatespell -index default\n4. indexMerge -config conf/textIndexer.conf1 -index default -config conf/textIndexer.conf2 -index default\n\nThis *experimental* command merges data from all the specified indexes into the \nfirst index.\n\n");
                Trace.untab();
                System.exit(1);
            }
            DirInfo[] dirInfos = new DirInfo[mergePaths.size()];
            boolean createTarget = false;
            int i = 0;
            while (i < mergePaths.size()) {
                String idxPath = (String)mergePaths.get(i);
                if (!IndexReader.indexExists(idxPath)) {
                    if (i != 0) throw new RuntimeException("Error: Cannot locate index in directory '" + idxPath + "'");
                    createTarget = true;
                    dirInfos[0] = new DirInfo(idxPath, null);
                } else {
                    FSDirectory srcDir = NativeFSDirectory.getDirectory(idxPath);
                    dirInfos[i] = IndexMerge.readInfo(idxPath, srcDir);
                    if (i == 1 && !createTarget || i > 1) {
                        if (dirInfos[i].chunkOverlap != dirInfos[i - 1].chunkOverlap) {
                            throw new RuntimeException("Error: index parameters must match exactly (chunkOverlap mismatch detected)");
                        }
                        if (dirInfos[i].chunkSize != dirInfos[i - 1].chunkSize) {
                            throw new RuntimeException("Error: index parameters must match exactly (chunkSize mismatch detected)");
                        }
                        if (!dirInfos[i].stopWords.equals(dirInfos[i - 1].stopWords)) {
                            throw new RuntimeException("Error: index parameters must match exactly (stopWords mismatch detected)");
                        }
                        if (!dirInfos[i].accentMapName.equals(dirInfos[i - 1].accentMapName)) {
                            throw new RuntimeException("Error: index parameters must match exactly (accentMapName mismatch detected)");
                        }
                        if (!dirInfos[i].pluralMapName.equals(dirInfos[i - 1].pluralMapName)) {
                            throw new RuntimeException("Error: index parameters must match exactly (pluralMapName mismatch detected)");
                        }
                    }
                }
                ++i;
            }
            IndexMerge.doMerge(dirInfos, createTarget);
        }
        catch (Exception e) {
            Trace.error("*** Last Chance Exception: " + e.getClass());
            Trace.error("             With message: " + e.getMessage());
            Trace.error("");
            e.printStackTrace(System.out);
            System.exit(1);
        }
        catch (Throwable t) {
            Trace.error("*** Last Chance Exception: " + t.getClass());
            Trace.error("             With message: " + t);
            Trace.error("");
            t.printStackTrace(System.out);
            System.exit(1);
        }
        System.exit(0);
    }

    private static DirInfo readInfo(String path, Directory dir) throws IOException {
        IndexReader indexReader = IndexReader.open(dir);
        try {
            Hits match = new IndexSearcher(indexReader).search(new TermQuery(new Term("indexInfo", "1")));
            if (match.length() == 0) {
                throw new IOException("Index missing indexInfo doc");
            }
            assert (match.id(0) == 0) : "indexInfo chunk must be first in index";
            Document doc = match.doc(0);
            DirInfo ret = new DirInfo(path, dir);
            ret.chunkSize = Integer.parseInt(doc.get("chunkSize"));
            ret.chunkOverlap = Integer.parseInt(doc.get("chunkOvlp"));
            ret.stopWords = doc.get("stopWords");
            ret.pluralMapName = doc.get("pluralMap");
            ret.accentMapName = doc.get("accentMap");
            DirInfo dirInfo = ret;
            return dirInfo;
        }
        finally {
            indexReader.close();
        }
    }

    private static void doMerge(DirInfo[] dirInfos, boolean createTarget) throws InterruptedException, IOException {
        String ending;
        long startTime = System.currentTimeMillis();
        Trace.info("Ready to merge data from the following index directories:");
        Trace.tab();
        int i = 1;
        while (i < dirInfos.length) {
            Trace.info(dirInfos[i].path);
            ++i;
        }
        Trace.untab();
        Trace.info("into (and including data from) index directory:");
        Trace.tab();
        Trace.info(dirInfos[0].path);
        Trace.untab();
        Trace.info("");
        Trace.info("Merge will begin in 5 seconds ... ");
        Thread.sleep(5000L);
        Trace.info("");
        Trace.info("Merging indexes ... ");
        Trace.tab();
        IndexWriter writer = new IndexWriter(NativeFSDirectory.getDirectory(dirInfos[0].path), (Analyzer)new StandardAnalyzer(), createTarget);
        IndexMerge.mergeSpelling(dirInfos);
        IndexMerge.mergeLazy(dirInfos);
        IndexMerge.mergeAux(dirInfos);
        IndexMerge.mergeLucene(writer, dirInfos);
        Trace.untab();
        long timeMsec = System.currentTimeMillis() - startTime;
        long timeSec = timeMsec / 1000L;
        long timeMin = timeSec / 60L;
        long timeHour = timeMin / 60L;
        Trace.info("Total time: ");
        if (timeHour > 0L) {
            ending = timeHour == 1L ? "" : "s";
            Trace.more(4, String.valueOf(timeHour) + " hour" + ending + ", ");
        }
        if (timeMin > 0L) {
            ending = timeMin % 60L == 1L ? "" : "s";
            Trace.more(4, String.valueOf(timeMin % 60L) + " minute" + ending + ", ");
        }
        ending = timeSec % 60L == 1L ? "" : "s";
        Trace.more(4, String.valueOf(timeSec % 60L) + " second" + ending + ".");
        Trace.info("Merge completed successfully.");
        Trace.info("");
    }

    private static void mergeSpelling(DirInfo[] dirInfos) throws IOException {
        File sourceFile;
        String sourceDir;
        boolean anyToDo = false;
        int i = 1;
        while (i < dirInfos.length) {
            sourceDir = dirInfos[i].path;
            sourceFile = new File(String.valueOf(sourceDir) + "spellDict/newWords.txt");
            if (sourceFile.isFile() || !sourceFile.canRead()) {
                anyToDo = true;
            }
            ++i;
        }
        if (!anyToDo) {
            return;
        }
        Trace.info("Processing spellcheck word lists ... ");
        i = 1;
        while (i < dirInfos.length) {
            sourceDir = dirInfos[i].path;
            sourceFile = new File(String.valueOf(sourceDir) + "spellDict/newWords.txt");
            if (sourceFile.isFile() || !sourceFile.canRead()) {
                String targetDir = dirInfos[0].path;
                Path.createPath(String.valueOf(targetDir) + "spellDict");
                File targetFile = new File(String.valueOf(targetDir) + "spellDict/newWords.txt");
                PrintWriter targetWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(targetFile, targetFile.isFile()), "UTF-8")));
                BufferedReader sourceReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(sourceFile), "UTF-8"));
                boolean eof = false;
                while (!eof) {
                    try {
                        String word = sourceReader.readLine();
                        if (word == null) {
                            eof = true;
                            continue;
                        }
                        targetWriter.println(word);
                    }
                    catch (EOFException e) {
                        eof = true;
                    }
                    catch (IOException e) {
                        Trace.warning("Warning: Exception encountered (may be due to unfinished index): " + e);
                        eof = true;
                    }
                }
                sourceReader.close();
                targetWriter.close();
            }
            ++i;
        }
        Trace.more("Done.");
    }

    private static void mergeAux(DirInfo[] dirInfos) throws IOException {
        boolean anyToDo = false;
        int i = 1;
        while (i < dirInfos.length) {
            String sourceDir = dirInfos[i].path;
            File accentFile = new File(String.valueOf(sourceDir) + dirInfos[i].accentMapName);
            File pluralFile = new File(String.valueOf(sourceDir) + dirInfos[i].pluralMapName);
            File tokFldFile = new File(String.valueOf(sourceDir) + "tokenizedFields.txt");
            if (accentFile.canRead() || pluralFile.canRead() || tokFldFile.canRead()) {
                anyToDo = true;
            }
            ++i;
        }
        if (!anyToDo) {
            return;
        }
        Trace.info("Processing auxiliary files ... ");
        i = 1;
        while (i < dirInfos.length) {
            File accentSrc = new File(dirInfos[i].path, dirInfos[i].accentMapName);
            File accentDst = new File(dirInfos[0].path, dirInfos[i].accentMapName);
            if (accentSrc.canRead() && !accentDst.canRead()) {
                Path.copyFile(accentSrc, accentDst);
            }
            File pluralSrc = new File(dirInfos[i].path, dirInfos[i].pluralMapName);
            File pluralDst = new File(dirInfos[0].path, dirInfos[i].pluralMapName);
            if (pluralSrc.canRead() && !pluralDst.canRead()) {
                Path.copyFile(pluralSrc, pluralDst);
            }
            File tokFldSrc = new File(dirInfos[i].path, "tokenizedFields.txt");
            File tokFldDst = new File(dirInfos[0].path, "tokenizedFields.txt");
            if (tokFldSrc.canRead() && !tokFldDst.canRead()) {
                IndexMerge.mergeTokFldFiles(tokFldSrc, tokFldDst);
            } else if (tokFldSrc.canRead() && tokFldDst.canRead()) {
                IndexMerge.mergeTokFldFiles(tokFldSrc, tokFldDst);
            }
            ++i;
        }
        Trace.more("Done.");
    }

    private static void mergeTokFldFiles(File file1, File file2) throws IOException {
        String line;
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        BufferedReader reader = new BufferedReader(new FileReader(file1));
        while ((line = reader.readLine()) != null) {
            set.add(line);
        }
        reader.close();
        FileWriter writer = new FileWriter(file1, true);
        reader = new BufferedReader(new FileReader(file2));
        while ((line = reader.readLine()) != null) {
            if (set.contains(line)) continue;
            writer.append(String.valueOf(line) + "\n");
        }
        writer.close();
    }

    private static void mergeLazy(DirInfo[] dirInfos) throws IOException {
        String sourceDir;
        String targetDir = dirInfos[0].path;
        boolean anyToDo = false;
        int i = 1;
        while (i < dirInfos.length) {
            sourceDir = dirInfos[i].path;
            File lazyDir = new File(sourceDir, "lazy");
            if (lazyDir.isDirectory()) {
                anyToDo = true;
            }
            ++i;
        }
        if (!anyToDo) {
            return;
        }
        Trace.info("Processing lazy tree files ... ");
        i = 1;
        while (i < dirInfos.length) {
            sourceDir = dirInfos[i].path;
            IndexMerge.mergeLazy(new File(sourceDir, "lazy"), new File(targetDir, "lazy"));
            ++i;
        }
        Trace.more("Done.");
    }

    private static void mergeLazy(File src, File dst) throws IOException {
        if (src.isFile()) {
            if (dst.isFile()) {
                return;
            }
            Path.copyFile(src, dst);
            return;
        }
        if (src.isDirectory()) {
            if (!dst.isDirectory() && !Path.createPath(dst.toString())) {
                throw new IOException("Error creating lazy file directory '" + dst + "'");
            }
            String[] subFiles = src.list();
            int i = 0;
            while (i < subFiles.length) {
                IndexMerge.mergeLazy(new File(src, subFiles[i]), new File(dst, subFiles[i]));
                ++i;
            }
        }
    }

    private static void mergeLucene(IndexWriter writer, DirInfo[] dirInfos) throws IOException {
        Trace.info("Processing Lucene indexes (can be very time-consuming) ... ");
        Directory[] dirs = new Directory[dirInfos.length - 1];
        int i = 1;
        while (i < dirInfos.length) {
            dirs[i - 1] = dirInfos[i].dir;
            ++i;
        }
        writer.addIndexes(dirs);
        writer.optimize();
        writer.close();
        Trace.more("Done.");
    }

    private static class DirInfo {
        String path;
        Directory dir;
        int chunkSize;
        int chunkOverlap;
        String stopWords;
        String pluralMapName;
        String accentMapName;

        public DirInfo(String idxPath, Directory srcDir) {
            this.path = idxPath;
            this.dir = srcDir;
        }
    }
}

