/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textIndexer;

import java.io.IOException;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.cdlib.xtf.util.CharMap;

public class AccentFoldingFilter
extends TokenFilter {
    private CharMap accentMap;

    public AccentFoldingFilter(TokenStream input, CharMap accentMap) {
        super(input);
        this.accentMap = accentMap;
    }

    public Token next() throws IOException {
        String mapped;
        Token t;
        int bumpAccum = 0;
        while (true) {
            if ((t = this.input.next()) == null) {
                return t;
            }
            String term = t.termText();
            mapped = this.accentMap.mapWord(term);
            if (mapped == null) {
                if (bumpAccum == 0) {
                    return t;
                }
                mapped = term;
            }
            if (mapped.length() != 0) break;
            bumpAccum += t.getPositionIncrement() - 1;
        }
        Token newToken = new Token(mapped, t.startOffset(), t.endOffset(), t.type());
        newToken.setPositionIncrement(t.getPositionIncrement() + bumpAccum);
        return newToken;
    }
}

