/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textEngine;

import java.io.IOException;
import java.text.ParseException;
import java.util.Set;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FieldSpanSource;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.spans.FieldSpans;
import org.cdlib.xtf.textEngine.BoostSet;
import org.cdlib.xtf.textEngine.BoostSetParams;
import org.cdlib.xtf.textEngine.DocHit;
import org.cdlib.xtf.textEngine.HitLoadException;
import org.cdlib.xtf.textEngine.Snippet;
import org.cdlib.xtf.textEngine.SnippetMaker;
import org.cdlib.xtf.util.AttribList;

public class DocHitImpl
extends DocHit {
    private SnippetMaker snippetMaker;
    private FieldSpanSource fieldSpanSource;
    private FieldSpans fieldSpans;
    private Snippet[] snippets;
    private String docKey;
    private long fileDate = -1L;
    private int recordNum = 0;
    private String subDocument = null;
    private int chunkCount = -1;
    private AttribList metaData;
    private Explanation explanation;

    DocHitImpl(int docNum, float score) {
        super(docNum, score);
    }

    void setSpanSource(FieldSpanSource src) {
        this.fieldSpanSource = src;
    }

    void finish(SnippetMaker snippetMaker, float docScoreNorm) {
        if (this.snippetMaker != null) {
            return;
        }
        this.snippetMaker = snippetMaker;
        this.score *= docScoreNorm;
    }

    void finishWithExplain(SnippetMaker snippetMaker, float docScoreNorm, Weight weight, BoostSet boostSet, BoostSetParams boostParams) throws IOException {
        if (this.snippetMaker != null) {
            return;
        }
        this.finish(snippetMaker, docScoreNorm);
        this.explanation = weight.explain(snippetMaker.reader, this.doc);
        if (boostSet != null) {
            Explanation result = new Explanation(0.0f, "boosted, product of:");
            Explanation boostExpl = new Explanation(boostSet.getBoost(this.doc, boostParams.defaultBoost), "boostSetFactor");
            if (boostParams.exponent != 1.0f) {
                Explanation exponentExpl = new Explanation((float)Math.pow(boostExpl.getValue(), boostParams.exponent), "exponentBoosted");
                exponentExpl.addDetail(boostExpl);
                exponentExpl.addDetail(new Explanation(boostParams.exponent, "boostSetExponent"));
                boostExpl = exponentExpl;
            }
            result.addDetail(boostExpl);
            result.addDetail(this.explanation);
            result.setValue(boostExpl.getValue() * this.explanation.getValue());
            this.explanation = result;
        }
    }

    private void load() {
        Document docContents;
        try {
            assert (!this.snippetMaker.reader.isDeleted(this.doc));
            docContents = this.snippetMaker.reader.document(this.doc);
        }
        catch (IOException e) {
            throw new HitLoadException(e);
        }
        Set returnMetaFields = this.snippetMaker.returnMetaFields();
        this.metaData = new AttribList();
        for (Field f : docContents.getFields()) {
            String name = f.name();
            String value = f.stringValue();
            if (name.equals("key")) {
                this.docKey = value;
                continue;
            }
            if (name.equals("fileDate")) {
                try {
                    this.fileDate = DateTools.stringToTime(value);
                }
                catch (ParseException parseException) {}
                continue;
            }
            if (name.equals("chunkCount")) {
                this.chunkCount = Integer.parseInt(value);
                continue;
            }
            if (name.equals("recordNum")) {
                this.recordNum = Integer.parseInt(value);
                continue;
            }
            if (name.equals("subDocument")) {
                this.subDocument = value;
                continue;
            }
            if (name.equals("docInfo") || returnMetaFields != null && !returnMetaFields.contains(name)) continue;
            this.loadMetaField(name, value, docContents, this.metaData, this.snippetMaker.tokFields().contains(f.name()));
        }
        assert (this.docKey != null) : "Incomplete data in index - missing 'key'";
        assert (this.chunkCount != -1) : "Incomplete data in index - missing 'chunkCount'";
    }

    private void loadMetaField(String name, String value, Document docContents, AttribList metaData, boolean isTokenized) {
        String markedValue = isTokenized ? this.snippetMaker.markField(docContents, this.fieldSpans, name, value) : value;
        StringBuilder buf = new StringBuilder(markedValue.length() * 2);
        char[] chars = markedValue.toCharArray();
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (c == '<' && i < markedValue.length() - 2 && markedValue.charAt(i + 1) == '$') {
                buf.append('<');
                buf.append(name);
                ++i;
            } else {
                if (buf.length() == 0) {
                    buf.append('<');
                    buf.append(name);
                    buf.append(">");
                }
                if (c != '\uebeb' && c != '\uee1d' && c != '\uebbb') {
                    buf.append(c);
                }
                if (i == chars.length - 1 || c == '\uebbb') {
                    buf.append("</");
                    buf.append(name);
                    buf.append('>');
                    String cleanedVal = buf.toString();
                    metaData.put(name, cleanedVal);
                    buf.delete(0, buf.length());
                    if (c == '\uebbb') {
                        ++i;
                        while (i < chars.length && chars[i] != '\uebbb') {
                            ++i;
                        }
                        if (++i < chars.length && Character.isWhitespace(chars[i])) {
                            ++i;
                        }
                        --i;
                    }
                }
            }
            ++i;
        }
    }

    public Set textTerms() {
        if (this.fieldSpans == null) {
            if (this.fieldSpanSource != null) {
                this.fieldSpans = this.fieldSpanSource.getSpans(this.doc);
            } else {
                return null;
            }
        }
        return this.fieldSpans.getTerms("text");
    }

    public final String filePath() {
        if (this.docKey == null) {
            this.load();
        }
        return this.docKey;
    }

    public final int recordNum() {
        if (this.docKey == null) {
            this.load();
        }
        return this.recordNum;
    }

    public final String subDocument() {
        if (this.docKey == null) {
            this.load();
        }
        return this.subDocument;
    }

    public final AttribList metaData() {
        if (this.docKey == null) {
            this.load();
        }
        return this.metaData;
    }

    public final int totalSnippets() {
        if (this.fieldSpans == null) {
            if (this.fieldSpanSource != null) {
                this.fieldSpans = this.fieldSpanSource.getSpans(this.doc);
            } else {
                return 0;
            }
        }
        return this.fieldSpans.getSpanTotal("text");
    }

    public final int nSnippets() {
        if (this.fieldSpans == null) {
            if (this.fieldSpanSource != null) {
                this.fieldSpans = this.fieldSpanSource.getSpans(this.doc);
            } else {
                return 0;
            }
        }
        return this.fieldSpans.getSpanCount("text");
    }

    public final Snippet snippet(int hitNum, boolean getText) {
        if (this.snippets == null || getText && this.snippets[hitNum].text == null) {
            this.snippets = this.snippetMaker.makeSnippets(this.fieldSpans, this.doc, "text", getText);
        }
        return this.snippets[hitNum];
    }

    public Explanation explanation() {
        return this.explanation;
    }
}

