/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.saxonExt.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.sf.saxon.Controller;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SimpleExpression;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.style.ExtensionInstruction;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.StringValue;

public class SQLQuery
extends ExtensionInstruction {
    Expression connection;
    Expression column;
    Expression table;
    Expression where;
    String rowTag;
    String colTag;
    boolean disable = false;

    public void prepareAttributes() throws XPathException {
        String disableAtt;
        String dbCol = this.attributeList.getValue("", "column");
        if (dbCol == null) {
            this.reportAbsence("column");
        }
        this.column = this.makeAttributeValueTemplate(dbCol);
        String dbTab = this.attributeList.getValue("", "table");
        if (dbTab == null) {
            this.reportAbsence("table");
        }
        this.table = this.makeAttributeValueTemplate(dbTab);
        String dbWhere = this.attributeList.getValue("", "where");
        this.where = dbWhere == null ? new StringLiteral(StringValue.EMPTY_STRING) : this.makeAttributeValueTemplate(dbWhere);
        String connectAtt = this.attributeList.getValue("", "connection");
        if (connectAtt == null) {
            this.reportAbsence("connection");
        } else {
            this.connection = this.makeExpression(connectAtt);
        }
        this.rowTag = this.attributeList.getValue("", "row-tag");
        if (this.rowTag == null) {
            this.rowTag = "row";
        }
        if (this.rowTag.indexOf(58) >= 0) {
            this.compileError("rowTag must not contain a colon");
        }
        this.colTag = this.attributeList.getValue("", "column-tag");
        if (this.colTag == null) {
            this.colTag = "col";
        }
        if (this.colTag.indexOf(58) >= 0) {
            this.compileError("colTag must not contain a colon");
        }
        if ((disableAtt = this.attributeList.getValue("", "disable-output-escaping")) != null) {
            if (disableAtt.equals("yes")) {
                this.disable = true;
            } else if (disableAtt.equals("no")) {
                this.disable = false;
            } else {
                this.compileError("disable-output-escaping attribute must be either yes or no");
            }
        }
    }

    public void validate() throws XPathException {
        super.validate();
        this.column = this.typeCheck("column", this.column);
        this.table = this.typeCheck("table", this.table);
        this.where = this.typeCheck("where", this.where);
        this.connection = this.typeCheck("connection", this.connection);
    }

    public Expression compile(Executable exec) throws XPathException {
        QueryInstruction inst = new QueryInstruction(this.connection, this.column, this.table, this.where, this.rowTag, this.colTag, this.disable);
        return inst;
    }

    private static class QueryInstruction
    extends SimpleExpression {
        public static final int CONNECTION = 0;
        public static final int COLUMN = 1;
        public static final int TABLE = 2;
        public static final int WHERE = 3;
        String rowTag;
        String colTag;
        int options;

        public QueryInstruction(Expression connection, Expression column, Expression table, Expression where, String rowTag, String colTag, boolean disable) {
            Expression[] sub = new Expression[]{connection, column, table, where};
            this.setArguments(sub);
            this.rowTag = rowTag;
            this.colTag = colTag;
            this.options = disable ? 1 : 0;
        }

        public int getImplementationMethod() {
            return 4;
        }

        public String getExpressionType() {
            return "sql:query";
        }

        public void process(XPathContext context) throws XPathException {
            Controller controller = context.getController();
            Item conn = this.arguments[0].evaluateItem(context);
            if (!(conn instanceof ObjectValue) || !(((ObjectValue)conn).getObject() instanceof Connection)) {
                DynamicError de = new DynamicError("Value of connection expression is not a JDBC Connection");
                de.setXPathContext(context);
                throw de;
            }
            Connection connection = (Connection)((ObjectValue)conn).getObject();
            String dbCol = this.arguments[1].evaluateAsString(context);
            String dbTab = this.arguments[2].evaluateAsString(context);
            String dbWhere = this.arguments[3].evaluateAsString(context);
            NamePool pool = controller.getNamePool();
            int rowCode = pool.allocate("", "", this.rowTag);
            int colCode = pool.allocate("", "", this.colTag);
            try {
                StringBuffer statement = new StringBuffer();
                statement.append("SELECT " + dbCol + " FROM " + dbTab);
                if (dbWhere != "") {
                    statement.append(" WHERE " + dbWhere);
                }
                PreparedStatement ps = connection.prepareStatement(statement.toString());
                controller.setUserData(this, "sql:statement", ps);
                ResultSet rs = ps.executeQuery();
                SequenceReceiver out = context.getReceiver();
                String result = "";
                int icol = rs.getMetaData().getColumnCount();
                while (rs.next()) {
                    out.startElement(rowCode, -1, this.locationId, 0);
                    int col = 1;
                    while (col <= icol) {
                        result = rs.getString(col);
                        out.startElement(colCode, -1, this.locationId, 0);
                        if (result != null) {
                            out.characters(result, this.locationId, this.options);
                        }
                        out.endElement();
                        ++col;
                    }
                    out.endElement();
                }
                rs.close();
                if (!connection.getAutoCommit()) {
                    connection.commit();
                }
            }
            catch (SQLException ex) {
                DynamicError de = new DynamicError("(SQL) " + ex.getMessage());
                de.setXPathContext(context);
                throw de;
            }
        }
    }
}

