/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.saxonExt.pipe;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.pdf.BadPdfFormatException;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.SimpleBookmark;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import net.sf.saxon.TransformerFactoryImpl;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tinytree.TinyBuilder;
import net.sf.saxon.trans.XPathException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.cdlib.xtf.saxonExt.ElementWithContent;
import org.cdlib.xtf.saxonExt.InstructionWithContent;
import org.cdlib.xtf.saxonExt.pipe.BufferedRandomAccessFile;
import org.cdlib.xtf.saxonExt.pipe.PipeFileElement;
import org.cdlib.xtf.servletBase.TextServlet;
import org.cdlib.xtf.util.Trace;
import org.cdlib.xtf.xslt.FileUtils;
import org.xml.sax.SAXException;

public class PipeFopElement
extends ElementWithContent {
    private static HashMap<String, FopFactory> fopFactories = new HashMap();
    private static Lock fopLock = new ReentrantLock();

    public void prepareAttributes() throws XPathException {
        String[] mandatoryAtts = new String[]{};
        String[] optionalAtts = new String[]{"fileName", "author", "creator", "keywords", "producer", "title", "overrideMetadata", "appendPDF", "mergePDFFile", "mergeAt", "mergeMode", "fallbackIfError", "fontDirs", "waitTime"};
        this.parseAttributes(mandatoryAtts, optionalAtts);
    }

    public Expression compile(Executable exec) throws XPathException {
        return new PipeFopInstruction(this.attribs, this.compileContent(exec));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MergeAt {
        START,
        END;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MergeMode {
        SEQUENTIAL,
        OVERLAY,
        UNDERLAY;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PipeFopInstruction
    extends InstructionWithContent {
        public PipeFopInstruction(Map<String, Expression> attribs, Expression content) {
            super("pipe:pipeFop", attribs, content);
        }

        @Override
        public TailCall processLeavingTail(XPathContext context) throws XPathException {
            block36: {
                HttpServletResponse servletResponse = TextServlet.getCurResponse();
                servletResponse.setHeader("Content-type", "application/pdf");
                String fileName = this.getAttribStr("fileName", context);
                if (fileName != null && fileName.length() != 0) {
                    servletResponse.setHeader("Content-disposition", "attachment; filename=\"" + fileName + "\"");
                }
                String nameToMerge = this.getAttribStr("mergePDFFile", context, this.getAttribStr("appendPDF", context, null));
                File fileToMerge = null;
                if (nameToMerge != null && !(fileToMerge = FileUtils.resolveFile(context, nameToMerge)).canRead()) {
                    this.dynamicError("Cannot read file '" + fileToMerge.toString() + "'", "PIPE_FOP_010", context);
                }
                MergeMode mergeMode = MergeMode.SEQUENTIAL;
                String tmp = this.getAttribStr("mergeMode", context, "sequential");
                if (tmp.equalsIgnoreCase("sequential")) {
                    mergeMode = MergeMode.SEQUENTIAL;
                } else if (tmp.equalsIgnoreCase("overlay")) {
                    mergeMode = MergeMode.OVERLAY;
                } else if (tmp.equalsIgnoreCase("underlay")) {
                    mergeMode = MergeMode.UNDERLAY;
                } else {
                    this.dynamicError("Unrecognized mergeMode '" + tmp + "'", "PIPE_FOP_008", context);
                }
                MergeAt mergeAt = MergeAt.START;
                tmp = this.getAttribStr("mergeAt", context, "start");
                if (tmp.equalsIgnoreCase("start")) {
                    mergeAt = MergeAt.START;
                } else if (tmp.equalsIgnoreCase("end")) {
                    mergeAt = MergeAt.END;
                } else {
                    this.dynamicError("Unrecognized mergeAt '" + tmp + "'", "PIPE_FOP_009", context);
                }
                try {
                    File finalOut;
                    System.setProperty("java.awt.headless", "true");
                    Item contentItem = this.content.evaluateItem(context);
                    NodeInfo src = TinyBuilder.build((Source)((Object)contentItem), null, context.getConfiguration());
                    TransformerFactoryImpl transFactory = new TransformerFactoryImpl();
                    Transformer transformer = ((TransformerFactory)transFactory).newTransformer();
                    File tempFile = new File(FileUtils.createTempFile(context, "xtfFop.", ".tmp"));
                    FileOutputStream fopOut = new FileOutputStream(tempFile);
                    int lockTime = this.attribs.containsKey("waitTime") ? Integer.parseInt(((Expression)this.attribs.get("waitTime")).evaluateAsString(context)) : 5;
                    boolean gotLock = false;
                    try {
                        if (lockTime <= 0) {
                            gotLock = true;
                            fopLock.lock();
                        } else {
                            gotLock = fopLock.tryLock(lockTime, TimeUnit.SECONDS);
                        }
                        if (!gotLock) {
                            throw new TimeoutException("Timed out trying to obtain FOP lock");
                        }
                        FopFactory fopFactory = this.createFopFactory(context);
                        FOUserAgent foAgent = fopFactory.newFOUserAgent();
                        if (this.attribs.containsKey("author")) {
                            foAgent.setAuthor(((Expression)this.attribs.get("author")).evaluateAsString(context));
                        }
                        if (this.attribs.containsKey("creator")) {
                            foAgent.setCreator(((Expression)this.attribs.get("creator")).evaluateAsString(context));
                        }
                        if (this.attribs.containsKey("keywords")) {
                            foAgent.setKeywords(((Expression)this.attribs.get("keywords")).evaluateAsString(context));
                        }
                        if (this.attribs.containsKey("producer")) {
                            foAgent.setProducer(((Expression)this.attribs.get("producer")).evaluateAsString(context));
                        }
                        if (this.attribs.containsKey("title")) {
                            foAgent.setTitle(((Expression)this.attribs.get("title")).evaluateAsString(context));
                        }
                        Fop fop = fopFactory.newFop("application/pdf", foAgent, (OutputStream)fopOut);
                        transformer.transform(src, new SAXResult(fop.getDefaultHandler()));
                    }
                    finally {
                        if (gotLock) {
                            fopLock.unlock();
                        }
                        if (fopOut != null) {
                            fopOut.close();
                        }
                    }
                    if (fileToMerge != null) {
                        File tempFile2;
                        finalOut = tempFile2 = new File(FileUtils.createTempFile(context, "xtfFopMerge.", ".tmp"));
                        BufferedOutputStream mergeOut = new BufferedOutputStream(new FileOutputStream(tempFile2));
                        try {
                            this.mergePdf(context, tempFile, fileToMerge, mergeMode, mergeAt, mergeOut);
                        }
                        finally {
                            ((OutputStream)mergeOut).close();
                        }
                    } else {
                        finalOut = tempFile;
                    }
                    servletResponse.setHeader("Content-length", Long.toString(finalOut.length()));
                    PipeFileElement.copyFileToStream(finalOut, (OutputStream)servletResponse.getOutputStream());
                }
                catch (Throwable e2) {
                    IOException e2;
                    if (fileToMerge != null && this.getAttribBool("fallbackIfError", context, true)) {
                        try {
                            Trace.warning("Warning: pipeFop failed, falling back to just piping PDF file. Cause: " + e2.toString());
                            servletResponse.setHeader("Content-length", Long.toString(fileToMerge.length()));
                            PipeFileElement.copyFileToStream(fileToMerge, (OutputStream)servletResponse.getOutputStream());
                            e2 = null;
                        }
                        catch (IOException e22) {
                            e2 = e22;
                        }
                    }
                    if (e2 == null) break block36;
                    String code = e2 instanceof IOException ? "PIPE_FOP_001" : (e2 instanceof TransformerException ? "PIPE_FOP_002" : (e2 instanceof FOPException ? "PIPE_FOP_003" : (e2 instanceof DocumentException ? "PIPE_FOP_004" : (e2 instanceof TimeoutException ? "PIPE_FOP_005" : "PIPE_FOP_006"))));
                    this.dynamicError(e2, "Error while piping FOP: " + e2.toString(), code, context);
                }
            }
            return null;
        }

        private FopFactory createFopFactory(XPathContext context) throws ConfigurationException, SAXException, IOException, XPathException {
            String fontDirs = "";
            if (this.attribs.containsKey("fontDirs")) {
                fontDirs = ((Expression)this.attribs.get("fontDirs")).evaluateAsString(context);
            }
            if (fopFactories.containsKey(fontDirs)) {
                return (FopFactory)fopFactories.get(fontDirs);
            }
            FopFactory factory = FopFactory.newInstance();
            if (fontDirs.length() > 0) {
                StringBuilder buf = new StringBuilder();
                buf.append("<?xml version=\"1.0\"?><fop version=\"1.0\">  <renderers>    <renderer mime=\"application/pdf\">      <fonts>");
                String[] stringArray = fontDirs.split(";");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String dir = stringArray[n2];
                    buf.append("        <directory>" + dir + "</directory>");
                    ++n2;
                }
                buf.append("      </fonts>    </renderer>  </renderers></fop>");
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)bos);
                osw.write(buf.toString());
                osw.flush();
                ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
                DefaultConfigurationBuilder cfgBuilder = new DefaultConfigurationBuilder();
                Configuration config = cfgBuilder.build((InputStream)bis);
                factory.setUserConfig(config);
            }
            fopFactories.put(fontDirs, factory);
            return factory;
        }

        private void mergePdf(XPathContext context, File origPdfData, File fileToAppend, MergeMode mergeMode, MergeAt mergeAt, OutputStream outStream) throws IOException, DocumentException, BadPdfFormatException, XPathException {
            RandomAccessFileOrArray[] randFiles = new RandomAccessFileOrArray[2];
            PdfReader[] readers = new PdfReader[2];
            HashMap[] infos = new HashMap[2];
            int[] nInPages = new int[2];
            int[] pageOffsets = new int[2];
            int nOutPages = 0;
            try {
                randFiles[0] = origPdfData.length() > 0x100000L ? new BufferedRandomAccessFile(origPdfData.toString()) : new RandomAccessFileOrArray(origPdfData.toString());
                randFiles[1] = fileToAppend.length() > 0x100000L ? new BufferedRandomAccessFile(fileToAppend.toString()) : new RandomAccessFileOrArray(fileToAppend.toString());
                readers[0] = new PdfReader(randFiles[0], null);
                readers[1] = new PdfReader(randFiles[1], null);
                int i = 0;
                while (i < 2) {
                    readers[i].consolidateNamedDestinations();
                    infos[i] = readers[i].getInfo();
                    nInPages[i] = readers[i].getNumberOfPages();
                    ++i;
                }
                switch (mergeMode) {
                    case SEQUENTIAL: {
                        nOutPages = nInPages[0] + nInPages[1];
                        switch (mergeAt) {
                            case START: {
                                pageOffsets[0] = nInPages[1];
                                pageOffsets[1] = 0;
                                break;
                            }
                            case END: {
                                pageOffsets[0] = 0;
                                pageOffsets[1] = nInPages[0];
                            }
                        }
                        break;
                    }
                    case OVERLAY: 
                    case UNDERLAY: {
                        nOutPages = Math.max(nInPages[0], nInPages[1]);
                        pageOffsets[0] = 0;
                        pageOffsets[1] = mergeAt == MergeAt.END ? Math.max(0, nInPages[0] - nInPages[1]) : 0;
                    }
                }
                Document pdfDocument = new Document(readers[0].getPageSizeWithRotation(1));
                PdfCopy pdfWriter = new PdfCopy(pdfDocument, outStream);
                pdfDocument.open();
                this.mergeMetadata(infos, (PdfWriter)pdfWriter, context);
                ArrayList allBookmarks = new ArrayList();
                int i2 = 0;
                while (i2 < 2) {
                    List bookmarks = SimpleBookmark.getBookmark((PdfReader)readers[i2]);
                    if (bookmarks != null) {
                        if (pageOffsets[i2] != 0) {
                            SimpleBookmark.shiftPageNumbers((List)bookmarks, (int)pageOffsets[i2], null);
                        }
                        allBookmarks.addAll(bookmarks);
                    }
                    ++i2;
                }
                PageInfo[] basePages = new PageInfo[nOutPages];
                PageInfo[] mergePages = new PageInfo[nOutPages];
                int i3 = 0;
                while (i3 < nOutPages) {
                    int j = 0;
                    while (j < 2) {
                        int inPageNum = i3 - pageOffsets[j];
                        if (inPageNum >= 0 && inPageNum < nInPages[j]) {
                            PageInfo info = new PageInfo();
                            info.reader = readers[j];
                            info.pageNum = inPageNum + 1;
                            if (basePages[i3] == null) {
                                basePages[i3] = info;
                            } else {
                                info.impPage = pdfWriter.getImportedPage(info.reader, info.pageNum);
                                info.image = Image.getInstance((PdfTemplate)info.impPage);
                                mergePages[i3] = info;
                            }
                        }
                        ++j;
                    }
                    ++i3;
                }
                i3 = 0;
                while (i3 < nOutPages) {
                    PageInfo basePage = basePages[i3];
                    PageInfo mergePage = mergePages[i3];
                    boolean over = mergeMode == MergeMode.OVERLAY;
                    basePage.impPage = pdfWriter.getImportedPage(basePage.reader, basePage.pageNum);
                    if (mergePage != null) {
                        PdfCopy.PageStamp ps = pdfWriter.createPageStamp(basePage.impPage);
                        PdfContentByte contentBuf = null;
                        contentBuf = over ? ps.getOverContent() : ps.getUnderContent();
                        Image img = Image.getInstance((Image)mergePage.image);
                        int rotation = mergePage.reader.getPageRotation(mergePage.pageNum);
                        float w = basePage.impPage.getWidth();
                        float h = basePage.impPage.getHeight();
                        switch (rotation) {
                            case 0: {
                                contentBuf.addImage(img, w, 0.0f, 0.0f, h, 0.0f, 0.0f);
                                break;
                            }
                            case 90: {
                                contentBuf.addImage(img, 0.0f, -h, w, 0.0f, 0.0f, h);
                                break;
                            }
                            case 180: {
                                contentBuf.addImage(img, -w, 0.0f, 0.0f, -h, w, h);
                                break;
                            }
                            case 270: {
                                contentBuf.addImage(img, 0.0f, h, -w, 0.0f, w, 0.0f);
                            }
                        }
                        ps.alterContents();
                    }
                    pdfWriter.addPage(basePage.impPage);
                    ++i3;
                }
                if (!allBookmarks.isEmpty()) {
                    pdfWriter.setOutlines(allBookmarks);
                }
                pdfDocument.close();
            }
            finally {
                if (randFiles[0] != null) {
                    try {
                        randFiles[0].close();
                    }
                    catch (Exception exception) {}
                }
                if (randFiles[1] != null) {
                    try {
                        randFiles[1].close();
                    }
                    catch (Exception exception) {}
                }
            }
        }

        private void mergeMetadata(HashMap<String, String>[] infos, PdfWriter pdfWriter, XPathContext context) throws XPathException {
            boolean override = this.getAttribBool("overrideMetadata", context, false);
            HashMap<String, String> toPut = new HashMap<String, String>();
            if (override) {
                toPut.putAll(infos[1]);
                toPut.putAll(infos[0]);
            } else {
                toPut.putAll(infos[0]);
                toPut.putAll(infos[1]);
            }
            PdfDictionary outInfo = pdfWriter.getInfo();
            for (String key : toPut.keySet()) {
                String val;
                if (key.equals("Producer") || (val = ((String)toPut.get(key)).trim()).length() == 0) continue;
                outInfo.put(new PdfName(key), (PdfObject)new PdfString(val, "UnicodeBig"));
            }
        }

        private static class PageInfo {
            PdfReader reader;
            int pageNum;
            PdfImportedPage impPage;
            Image image;

            private PageInfo() {
            }
        }
    }
}

