/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.lazyTree;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Set;
import java.util.regex.Pattern;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeListIterator;
import net.sf.saxon.om.StrippedNode;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.cdlib.xtf.lazyTree.ElementImpl;
import org.cdlib.xtf.lazyTree.LazyDocument;
import org.cdlib.xtf.lazyTree.LazyTreeBuilder;
import org.cdlib.xtf.lazyTree.NodeImpl;
import org.cdlib.xtf.lazyTree.ParentNodeImpl;
import org.cdlib.xtf.lazyTree.ProxyElement;
import org.cdlib.xtf.lazyTree.SearchElement;
import org.cdlib.xtf.lazyTree.SearchElementImpl;
import org.cdlib.xtf.lazyTree.SearchNode;
import org.cdlib.xtf.lazyTree.SearchTextImpl;
import org.cdlib.xtf.textEngine.DocHit;
import org.cdlib.xtf.textEngine.QueryProcessor;
import org.cdlib.xtf.textEngine.QueryRequest;
import org.cdlib.xtf.textEngine.QueryResult;
import org.cdlib.xtf.textEngine.Snippet;
import org.cdlib.xtf.util.CharMap;
import org.cdlib.xtf.util.CheckingTokenStream;
import org.cdlib.xtf.util.EasyNode;
import org.cdlib.xtf.util.FastStringReader;
import org.cdlib.xtf.util.FastTokenizer;
import org.cdlib.xtf.util.Normalizer;
import org.cdlib.xtf.util.StructuredStore;
import org.cdlib.xtf.util.Trace;
import org.cdlib.xtf.util.WordMap;

public class SearchTree
extends LazyDocument {
    String sourceKey;
    Set termMap;
    Set stopSet;
    WordMap pluralMap;
    CharMap accentMap;
    int totalHits = 0;
    int nHits = 0;
    Snippet[] hitsByScore = new Snippet[0];
    DocHit[] hitsToDocHit = new DocHit[0];
    int[] hitsToDocHitNum = new int[0];
    Snippet[] hitsByLocation = new Snippet[0];
    int[] hitRankToNum;
    int termMode;
    boolean suppressScores;
    static final int MARKER_BASE = 1000000000;
    static final int MARKER_RANGE = 100000000;
    static final int PREV_SIB_MARKER = 1100000000;
    static final int HIT_ELMT_MARKER = 1200000000;
    static final int SNIPPET_MARKER = 1300000000;
    static final int VIRTUAL_MARKER = 1400000000;
    int nextVirtualNum = 1400000001;
    SearchElementImpl topSnippetNode;
    static final String xtfURI = "http://cdlib.org/xtf";
    int xtfNamespaceCode;
    int hitElementFingerprint;
    int snippetElementFingerprint;
    int hitElementCode;
    int moreElementCode;
    int termElementCode;
    int snippetElementCode;
    int snippetsElementCode;
    int xtfHitCountAttrCode;
    int xtfFirstHitAttrCode;
    int hitCountAttrCode;
    int totalHitCountAttrCode;
    int scoreAttrCode;
    int rankAttrCode;
    int hitNumAttrCode;
    int continuesAttrCode;
    int sectionTypeAttrCode;
    int subDocumentAttrCode;
    private static final Pattern ampPattern = Pattern.compile("&amp;");
    private static final Pattern ltPattern = Pattern.compile("&lt;");
    private static final Pattern gtPattern = Pattern.compile("&gt;");

    public SearchTree(Configuration config, String sourceKey, StructuredStore treeStore) throws FileNotFoundException, IOException {
        super(config);
        this.sourceKey = sourceKey;
        LazyTreeBuilder builder = new LazyTreeBuilder(config);
        builder.setNamePool(config.getNamePool());
        builder.load(treeStore, this);
        this.addXTFNamespace();
        this.hitElementCode = this.getNameCode("hit", true);
        this.moreElementCode = this.getNameCode("more", true);
        this.termElementCode = this.getNameCode("term", true);
        this.snippetElementCode = this.getNameCode("snippet", true);
        this.snippetsElementCode = this.getNameCode("snippets", true);
        this.xtfHitCountAttrCode = this.getNameCode("hitCount", true);
        this.xtfFirstHitAttrCode = this.getNameCode("firstHit", true);
        this.hitCountAttrCode = this.getNameCode("hitCount", false);
        this.totalHitCountAttrCode = this.getNameCode("totalHitCount", false);
        this.scoreAttrCode = this.getNameCode("score", false);
        this.rankAttrCode = this.getNameCode("rank", false);
        this.hitNumAttrCode = this.getNameCode("hitNum", false);
        this.continuesAttrCode = this.getNameCode("more", false);
        this.sectionTypeAttrCode = this.getNameCode("sectionType", false);
        this.subDocumentAttrCode = this.getNameCode("subDocument", false);
        this.hitElementFingerprint = this.namePool.getFingerprint(xtfURI, "hit");
        this.snippetElementFingerprint = this.namePool.getFingerprint(xtfURI, "snippet");
    }

    private int getNameCode(String name, boolean withNamespace) {
        if (!withNamespace) {
            return this.namePool.allocate("", "", name);
        }
        String prefix = this.namePool.suggestPrefixForURI(xtfURI);
        if (prefix == null) {
            prefix = "xtf";
        }
        return this.namePool.allocate(prefix, xtfURI, name);
    }

    public void suppressScores(boolean flag) {
        this.suppressScores = flag;
    }

    public void search(QueryProcessor processor, QueryRequest origReq) throws IOException {
        QueryRequest req = (QueryRequest)origReq.clone();
        if (req.query instanceof SpanQuery) assert (((SpanQuery)req.query).getSpanRecording() != 0);
        assert (req.maxDocs != 0);
        assert (req.startDoc == 0);
        this.termMode = req.termMode;
        req.termMode = Math.min(req.termMode, 2);
        BooleanQuery bq = new BooleanQuery();
        bq.add(new TermQuery(new Term("docInfo", "1")), BooleanClause.Occur.MUST);
        Term t = new Term("key", this.sourceKey);
        bq.add(new TermQuery(t), BooleanClause.Occur.MUST);
        bq.add(req.query, BooleanClause.Occur.MUST);
        req.query = bq;
        QueryResult result = processor.processRequest(req);
        this.nHits = 0;
        this.totalHits = 0;
        int i = 0;
        while (i < result.docHits.length) {
            this.nHits += result.docHits[i].nSnippets();
            this.totalHits += result.docHits[i].totalSnippets();
            ++i;
        }
        this.hitsToDocHit = new DocHit[this.nHits];
        this.hitsToDocHitNum = new int[this.nHits];
        this.hitsByScore = new Snippet[this.nHits];
        int n = 0;
        int i2 = 0;
        while (i2 < result.docHits.length) {
            DocHit docHit = result.docHits[i2];
            int j = 0;
            while (j < docHit.nSnippets()) {
                this.hitsToDocHit[n] = docHit;
                this.hitsToDocHitNum[n] = j;
                this.hitsByScore[n] = docHit.snippet(j, false);
                ++n;
                ++j;
            }
            ++i2;
        }
        assert (n == this.nHits);
        if (this.nHits > 0) {
            this.termMap = result.textTerms;
            this.stopSet = result.context.stopSet;
            this.pluralMap = result.context.pluralMap;
            this.accentMap = result.context.accentMap;
        }
        this.hitsByLocation = new Snippet[this.hitsByScore.length];
        System.arraycopy(this.hitsByScore, 0, this.hitsByLocation, 0, this.hitsByScore.length);
        Arrays.sort(this.hitsByLocation, new Comparator(){

            public int compare(Object o1, Object o2) {
                Snippet s1 = (Snippet)o1;
                Snippet s2 = (Snippet)o2;
                int n = s1.startNode - s2.startNode;
                if (n != 0) {
                    return n;
                }
                n = s1.startOffset - s2.startOffset;
                if (n != 0) {
                    return n;
                }
                String str1 = SearchTree.this.hitsToDocHit[s1.rank].snippet((int)SearchTree.this.hitsToDocHitNum[s1.rank], (boolean)true).text;
                String str2 = SearchTree.this.hitsToDocHit[s2.rank].snippet((int)SearchTree.this.hitsToDocHitNum[s2.rank], (boolean)true).text;
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"Chunk hits should never overlap!");
                }
                return 0;
            }
        });
        i2 = 0;
        while (i2 < this.nHits - 1) {
            Snippet s1 = this.hitsByLocation[i2];
            Snippet s2 = this.hitsByLocation[i2 + 1];
            assert (s1.endNode >= s1.startNode);
            assert (s2.endNode >= s2.startNode);
            assert (s2.startNode >= s1.endNode);
            if (s2.startNode == s1.endNode && s2.startOffset < s1.endOffset) {
                s1 = this.hitsToDocHit[s1.rank].snippet(this.hitsToDocHitNum[s1.rank], true);
                s2 = this.hitsToDocHit[s2.rank].snippet(this.hitsToDocHitNum[s2.rank], true);
                String t1 = s1.text;
                String t2 = s2.text;
                assert (false);
            }
            ++i2;
        }
        this.hitRankToNum = new int[this.nHits];
        i2 = 0;
        while (i2 < this.nHits) {
            this.hitRankToNum[this.hitsByLocation[i2].rank] = i2;
            ++i2;
        }
        this.addSnippets();
    }

    public NodeImpl getNode(int num) {
        if (num == -1) {
            return null;
        }
        NodeImpl node = this.checkCache(num);
        if (node != null) {
            return node;
        }
        if (num >= 1300000000 && num < 1400000000) {
            return (SearchElementImpl)this.createSnippetNode(num, true);
        }
        if (num >= 1200000000 && num < 1300000000) {
            return this.getHitElement(num - 1200000000);
        }
        int normNum = num;
        if (num >= 1100000000 && num < 1200000000 && (node = this.checkCache(normNum = num - 1100000000)) != null) {
            if (this.allPermanent) {
                this.nodeCache.put(num, node);
            } else {
                this.nodeCache.put(num, new SoftReference<NodeImpl>(node));
            }
            return node;
        }
        node = super.getNode(normNum);
        if (node == null) {
            return null;
        }
        if (this.allPermanent) {
            this.nodeCache.put(normNum, node);
        }
        assert (node.parentNum >= 0 || node == this);
        assert (node.nextSibNum >= -1);
        assert (node.prevSibNum >= -1);
        assert (node.parentNum < 0 || node.parentNum < 1000000000);
        assert (node.nextSibNum < 1000000000);
        assert (node.prevSibNum < 1000000000);
        assert (node.prevSibNum != node.nextSibNum || node.prevSibNum < 0);
        if (node.prevSibNum >= 0) {
            node.prevSibNum += 1100000000;
            assert (node.prevSibNum >= 0);
        }
        if (node instanceof SearchTextImpl) {
            node = this.expandText((SearchTextImpl)node, normNum != num);
        }
        if (num >= 1000000000) {
            this.nodeCache.put(num, node);
        }
        return node;
    }

    private void addXTFNamespace() {
        assert (this.numberOfNamespaces >= 1) : "must start with root namespace";
        ++this.numberOfNamespaces;
        int[] codes2 = new int[this.numberOfNamespaces];
        System.arraycopy(this.namespaceCode, 0, codes2, 0, this.numberOfNamespaces - 1);
        this.namespaceCode = codes2;
        int[] parents2 = new int[this.numberOfNamespaces];
        System.arraycopy(this.namespaceParent, 0, parents2, 0, this.numberOfNamespaces - 1);
        this.namespaceParent = parents2;
        this.namespaceCode[this.numberOfNamespaces - 1] = this.xtfNamespaceCode = this.namePool.allocateNamespaceCode("xtf", xtfURI);
        this.namespaceParent[this.numberOfNamespaces - 1] = 1;
        ElementImpl rootKid = this.getRootKid();
        this.modifyNode(rootKid);
        rootKid.nameSpace = this.numberOfNamespaces - 1;
    }

    private ElementImpl getRootKid() {
        EasyNode root = new EasyNode(this);
        int i = 0;
        while (i < root.nChildren()) {
            EasyNode kid = root.child(i);
            if (kid.isElement()) {
                return (ElementImpl)kid.getWrappedNode();
            }
            ++i;
        }
        throw new RuntimeException("Internal error: Search tree does not appear to have a root element");
    }

    private SearchElementImpl getHitElement(int hitNum) {
        NodeImpl tn = this.getNode(this.hitsByLocation[hitNum].startNode);
        assert (tn instanceof SearchTextImpl) : "Lazy file text node does not match index node number";
        SearchElementImpl el = (SearchElementImpl)this.nodeCache.get(1200000000 + hitNum);
        assert (el != null) : "Search element must be created with its text";
        return el;
    }

    protected NodeImpl createElementNode() {
        return new SearchElementImpl(this);
    }

    protected NodeImpl createTextNode() {
        return new SearchTextImpl(this);
    }

    protected NodeImpl checkCache(int num) {
        NodeImpl node = super.checkCache(num);
        assert (node != null || num < 1400000000 || num >= 1500000000) : "Missing virtual node";
        return node;
    }

    private NodeImpl expandText(SearchTextImpl origNode, boolean returnLastNode) {
        int num = origNode.nodeNum;
        int hitNum = this.findFirstHit(num);
        SearchTextImpl curNode = origNode;
        String text = curNode.getStringValue();
        int textLen = text.length();
        Snippet snippet = null;
        int hitStart = -1;
        int hitEnd = -1;
        if (hitNum < this.nHits) {
            snippet = this.hitsByLocation[hitNum];
            if (num < snippet.startNode) {
                snippet = null;
            } else {
                hitStart = num == snippet.startNode ? snippet.startOffset : 0;
                int n = hitEnd = num == snippet.endNode ? snippet.endOffset : Integer.MAX_VALUE;
            }
        }
        if (this.termMode < 3 && hitStart < 0) {
            return origNode;
        }
        boolean check = false;
        TokenStream tokenizer = new FastTokenizer(new FastStringReader(text));
        if (check) {
            StandardTokenizer stdTok = new StandardTokenizer(new StringReader(text));
            tokenizer = new CheckingTokenStream(tokenizer, stdTok);
        }
        tokenizer = new StandardFilter(tokenizer);
        int wordOffset = 0;
        int startChar = 0;
        int endChar = 0;
        boolean inHit = false;
        while (true) {
            SearchElementImpl el;
            Token token;
            try {
                token = tokenizer.next();
            }
            catch (Exception e) {
                assert (false) : "How can string tokenization fail?!";
                throw new RuntimeException(e);
            }
            if (token != null && snippet != null && snippet.startNode == num) {
                endChar = token.startOffset();
            }
            String mappedTerm = null;
            if (token != null) {
                String singular;
                String unaccented;
                mappedTerm = token.termText().toLowerCase();
                mappedTerm = Normalizer.normalize(mappedTerm);
                if (this.accentMap != null && (unaccented = this.accentMap.mapWord(mappedTerm)) != null) {
                    mappedTerm = unaccented;
                }
                if (this.pluralMap != null && (singular = this.pluralMap.lookup(mappedTerm)) != null) {
                    mappedTerm = singular;
                }
            }
            if (wordOffset == hitStart) {
                assert (snippet.startNode != num || this.termMap.contains(mappedTerm)) : "first hit token must be in search terms";
                assert (!inHit);
                inHit = true;
                curNode.setStringValue(text.substring(startChar, endChar));
                boolean firstForHit = snippet.startNode == num;
                boolean lastForHit = snippet.endNode == num;
                el = (SearchElementImpl)this.createHitElement(firstForHit, lastForHit, hitNum, true);
                this.linkSibling(curNode, el);
                curNode = this.addText(el, text.substring(endChar, textLen), true);
                startChar = endChar;
                inHit = true;
            }
            if (token == null) break;
            ++wordOffset;
            if (this.termMap != null && this.termMap.contains(mappedTerm) && (this.termMode == 3 || this.termMode >= 1 && inHit) && (inHit || this.stopSet == null || !this.stopSet.contains(mappedTerm))) {
                int soff = token.startOffset();
                int eoff = token.endOffset();
                curNode.setStringValue(text.substring(startChar, soff));
                el = this.addElement(curNode, this.termElementCode, 0, false);
                this.addText(el, text.substring(soff, eoff), true);
                curNode = this.addText(el, text.substring(eoff, textLen), false);
                startChar = token.endOffset();
            }
            endChar = token.endOffset();
            if (hitEnd < 0 || wordOffset <= hitEnd) continue;
            assert (snippet.endNode != num || this.termMap.contains(mappedTerm)) : "last hit token must be a search term";
            assert (inHit);
            inHit = false;
            curNode.setStringValue(text.substring(startChar, endChar));
            SearchElementImpl el2 = (SearchElementImpl)curNode.getParent();
            curNode = this.addText(el2, text.substring(endChar, textLen), false);
            startChar = endChar;
            inHit = false;
            snippet = null;
            hitEnd = -1;
            hitStart = -1;
            if (++hitNum >= this.nHits) continue;
            snippet = this.hitsByLocation[hitNum];
            if (num < snippet.startNode) {
                snippet = null;
                continue;
            }
            hitStart = num == snippet.startNode ? snippet.startOffset : 0;
            hitEnd = num == snippet.endNode ? snippet.endOffset : Integer.MAX_VALUE;
        }
        if (returnLastNode) {
            if (inHit) {
                return (NodeImpl)curNode.getParent();
            }
            return curNode;
        }
        return origNode;
    }

    SearchElement createHitElement(boolean firstForHit, boolean lastForHit, int hitNum, boolean realNotProxy) {
        Snippet snippet = this.hitsByLocation[hitNum];
        int nameCode = firstForHit ? this.hitElementCode : this.moreElementCode;
        int nAttrs = this.suppressScores ? 3 : 4;
        NodeImpl el = realNotProxy ? new SearchElementImpl(this) : new ProxyElement(this);
        this.initElement((SearchElement)((Object)el), nameCode, nAttrs);
        if (firstForHit) {
            el.setNodeNum(1200000000 + hitNum);
        }
        int attrNum = 0;
        if (!this.suppressScores) {
            el.setAttribute(attrNum++, this.scoreAttrCode, Integer.toString(Math.round(snippet.score * 100.0f)));
        }
        el.setAttribute(attrNum++, this.rankAttrCode, Integer.toString(snippet.rank + 1));
        el.setAttribute(attrNum++, this.hitNumAttrCode, Integer.toString(hitNum + 1));
        el.setAttribute(attrNum++, this.continuesAttrCode, lastForHit ? "no" : "yes");
        assert (attrNum == nAttrs);
        return el;
    }

    private SearchElementImpl addElement(NodeImpl prev, int elNameCode, int nAttribs, boolean addAsChild) {
        SearchElementImpl el = this.createElement(elNameCode, nAttribs);
        if (addAsChild) {
            this.linkChild((ParentNodeImpl)prev, el);
        } else {
            this.linkSibling(prev, el);
        }
        return el;
    }

    private SearchTextImpl addText(NodeImpl prev, String text, boolean addAsChild) {
        SearchTextImpl textNode = this.createText(text);
        if (addAsChild) {
            this.linkChild((ParentNodeImpl)prev, textNode);
        } else {
            this.linkSibling(prev, textNode);
        }
        return textNode;
    }

    private SearchElementImpl createElement(int elNameCode, int nAttribs) {
        SearchElementImpl el = new SearchElementImpl(this);
        this.initElement(el, elNameCode, nAttribs);
        return el;
    }

    private void initElement(SearchElement el, int elNameCode, int nAttrs) {
        this.initNode(el);
        el.allocateAttributes(nAttrs);
        el.setNameCode(elNameCode);
    }

    private SearchTextImpl createText(String text) {
        SearchTextImpl node = new SearchTextImpl(this);
        this.initNode(node);
        node.setStringValue(text);
        return node;
    }

    private void linkSibling(NodeImpl prev, NodeImpl node) {
        NodeImpl next = (NodeImpl)prev.getNextSibling();
        this.modifyNode(prev);
        this.modifyNode(next);
        node.parentNum = prev.parentNum;
        node.prevSibNum = prev.nodeNum;
        node.nextSibNum = prev.nextSibNum;
        prev.nextSibNum = node.nodeNum;
        if (next != null) {
            next.prevSibNum = node.nodeNum;
        }
    }

    private void linkChild(ParentNodeImpl parent, NodeImpl node) {
        this.modifyNode(parent);
        node.parentNum = parent.nodeNum;
        node.prevSibNum = -1;
        node.nextSibNum = parent.childNum;
        parent.childNum = node.nodeNum;
    }

    private void initNode(SearchNode node) {
        node.setNodeNum(this.nextVirtualNum);
        if (!(node instanceof ProxyElement)) {
            this.nodeCache.put(this.nextVirtualNum, node);
        }
        ++this.nextVirtualNum;
    }

    private void modifyNode(NodeImpl node) {
        if (node != null) {
            this.nodeCache.put(node.nodeNum, node);
        }
    }

    private void addSnippets() {
        ElementImpl rootKid = this.getRootKid();
        this.topSnippetNode = this.addElement(rootKid, this.snippetsElementCode, 2, true);
        this.topSnippetNode.setAttribute(0, this.totalHitCountAttrCode, Integer.toString(this.totalHits));
        this.topSnippetNode.setAttribute(1, this.hitCountAttrCode, Integer.toString(this.nHits));
        if (this.nHits > 0) {
            this.topSnippetNode.childNum = 1300000000;
        }
    }

    private SearchElement createSnippetNode(int num, boolean realNotProxy) {
        int hitNum = num - 1300000000;
        DocHit docHit = this.hitsToDocHit[hitNum];
        Snippet snippet = realNotProxy ? docHit.snippet(this.hitsToDocHitNum[hitNum], true) : this.hitsByScore[hitNum];
        int nAttribs = 2 + (snippet.sectionType != null ? 1 : 0) + (this.suppressScores ? 0 : 1) + (docHit.subDocument() == null ? 0 : 1);
        NodeImpl snippetElement = realNotProxy ? new SearchElementImpl(this) : new ProxyElement(this);
        this.initElement((SearchElement)((Object)snippetElement), this.snippetElementCode, nAttribs);
        snippetElement.setPrevSibNum(hitNum == 0 ? -1 : 1300000000 + hitNum - 1);
        snippetElement.setNextSibNum(hitNum == this.nHits - 1 ? -1 : 1300000000 + hitNum + 1);
        snippetElement.setParentNum(this.topSnippetNode.nodeNum);
        snippetElement.setNodeNum(num);
        if (realNotProxy) {
            this.nodeCache.put(num, snippetElement);
        }
        int attrNum = 0;
        if (!this.suppressScores) {
            snippetElement.setAttribute(attrNum++, this.scoreAttrCode, Integer.toString(Math.round(snippet.score * 100.0f)));
        }
        snippetElement.setAttribute(attrNum++, this.rankAttrCode, Integer.toString(hitNum + 1));
        snippetElement.setAttribute(attrNum++, this.hitNumAttrCode, Integer.toString(this.hitRankToNum[hitNum] + 1));
        if (snippet.sectionType != null) {
            snippetElement.setAttribute(attrNum++, this.sectionTypeAttrCode, snippet.sectionType);
        }
        if (docHit.subDocument() != null) {
            snippetElement.setAttribute(attrNum++, this.subDocumentAttrCode, docHit.subDocument());
        }
        assert (attrNum == nAttribs);
        if (!realNotProxy) {
            return snippetElement;
        }
        String text = snippet.text;
        int hitStart = text.indexOf("<hit");
        assert (hitStart >= 0) : "missing <hit> in snippet";
        String beforeText = text.substring(0, hitStart);
        NodeImpl prev = this.breakupText(beforeText, (SearchElementImpl)snippetElement, true);
        int hitTextStart = text.indexOf(62, hitStart) + 1;
        int hitEnd = text.indexOf("</hit>");
        assert (hitEnd >= 0) : "missing </hit> in snippet";
        prev = this.addElement(prev, this.hitElementCode, 0, false);
        String hitText = text.substring(hitTextStart, hitEnd);
        this.breakupText(hitText, prev, true);
        int textResume = text.indexOf(62, hitEnd) + 1;
        String afterText = text.substring(textResume);
        prev = this.breakupText(afterText, prev, false);
        return snippetElement;
    }

    private String undoEntities(String str) {
        if (str.indexOf("&amp;") >= 0) {
            str = ampPattern.matcher(str).replaceAll("&");
        }
        if (str.indexOf("&lt;") >= 0) {
            str = ltPattern.matcher(str).replaceAll("<");
        }
        if (str.indexOf("&gt;") >= 0) {
            str = gtPattern.matcher(str).replaceAll(">");
        }
        return str;
    }

    private NodeImpl breakupText(String text, NodeImpl prev, boolean addAsChild) {
        int startPos = 0;
        while (true) {
            int markerPos;
            if ((markerPos = text.indexOf("<term", startPos)) < 0) {
                markerPos = text.length();
            }
            String beforeText = text.substring(startPos, markerPos);
            beforeText = this.undoEntities(beforeText);
            prev = this.addText(prev, beforeText, addAsChild);
            addAsChild = false;
            if (markerPos == text.length()) break;
            int termStart = text.indexOf(62, markerPos) + 1;
            int markEnd = text.indexOf("</term>", markerPos);
            String termText = text.substring(termStart, markEnd);
            termText = this.undoEntities(termText);
            prev = this.addElement(prev, this.termElementCode, 0, false);
            this.addText(prev, termText, true);
            startPos = text.indexOf(62, markEnd) + 1;
        }
        return prev;
    }

    int findFirstHit(final int nodeNum) {
        int hitNum = Arrays.binarySearch(this.hitsByLocation, null, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Snippet)o1).endNode < nodeNum ? -1 : 1;
            }
        });
        assert (hitNum < 0) : "Comparator should never return an exact match";
        hitNum = -hitNum - 1;
        assert (hitNum >= 0 && hitNum <= this.nHits);
        return hitNum;
    }

    int findLastHit(int nodeNum) {
        NodeImpl node = this.getNode(nodeNum);
        while (node != null) {
            NodeImpl sib = (NodeImpl)node.getNextSibling();
            if (sib != null) {
                node = sib;
                break;
            }
            node = (ParentNodeImpl)node.getParent();
        }
        int lastNodeNum = node == null ? this.numberOfNodes : node.nodeNum;
        return this.findFirstHit(lastNodeNum);
    }

    public void putIndex(String indexName, HashMap index) throws IOException {
        for (ArrayList list : index.values()) {
            int i = 0;
            while (i < list.size()) {
                NodeImpl node;
                Item item = (Item)list.get(i);
                NodeImpl nodeImpl = item instanceof ProxyElement ? null : (item instanceof NodeImpl ? (NodeImpl)item : (node = item instanceof StrippedNode ? (NodeImpl)((StrippedNode)item).getUnderlyingNode() : null));
                if (node == null || node.nodeNum >= 1000000000 || node instanceof ParentNodeImpl && ((ParentNodeImpl)node).childNum >= 1000000000) {
                    throw new RuntimeException("Error: Key index '" + indexName + "' references virtual search-related nodes.\n" + "Change the key so it doesn't reference dynamic " + "nodes, or else change the key's name to contain " + "'dynamic' so it won't be stored.");
                }
                ++i;
            }
        }
        super.putIndex(indexName, index);
    }

    protected AxisIterator getAllElements(int fingerprint) {
        if (fingerprint != this.hitElementFingerprint && fingerprint != this.snippetElementFingerprint) {
            return super.getAllElements(fingerprint);
        }
        Trace.debug("    Building DYNAMIC list of elements named '" + this.namePool.getClarkName(fingerprint) + "'...");
        ArrayList<SearchElement> items = new ArrayList<SearchElement>(this.nHits);
        if (fingerprint == this.snippetElementFingerprint) {
            int i = 0;
            while (i < this.nHits) {
                items.add(this.createSnippetNode(i, false));
                ++i;
            }
        } else {
            assert (fingerprint == this.hitElementFingerprint) : "incorrect switching";
            int i = 0;
            while (i < this.nHits) {
                Snippet snippet = this.hitsByLocation[i];
                boolean lastForHit = snippet.startNode == snippet.endNode;
                items.add(this.createHitElement(true, lastForHit, i, false));
                ++i;
            }
        }
        Trace.debug("done");
        return new NodeListIterator(items);
    }

    public void pruneUnused() {
        assert (this.allPermanent) : "allPermanent should be true for pruneUnused()";
        NodeImpl[] stack = new NodeImpl[(this.numberOfNodes + this.nHits) * 3];
        int top = 0;
        for (Object ref : this.nodeCache.values()) {
            if (ref instanceof NodeImpl) {
                stack[top++] = (NodeImpl)ref;
                continue;
            }
            assert (false) : "allPermanent should be true for pruneUnused()";
        }
        while (top > 0) {
            NodeImpl node = stack[--top];
            if (node.prevSibNum >= 0) {
                if (!this.nodeCache.containsKey(node.prevSibNum)) {
                    stack[top++] = this.getNode(node.prevSibNum);
                }
                assert (this.nodeCache.containsKey(node.prevSibNum));
            }
            if (node.parentNum == 0) continue;
            stack[top++] = this.getNode(node.parentNum);
        }
        for (NodeImpl node : this.nodeCache.values()) {
            if (node.prevSibNum >= 0 && !this.nodeCache.containsKey(node.prevSibNum)) assert (false) : "Should have loaded prev sib";
            if (node.nextSibNum >= 0 && !this.nodeCache.containsKey(node.nextSibNum)) {
                node.nextSibNum = -1;
            }
            if (!(node instanceof ParentNodeImpl)) continue;
            ParentNodeImpl pnode = (ParentNodeImpl)node;
            if (pnode.childNum < 0 || this.nodeCache.containsKey(pnode.childNum)) continue;
            pnode.childNum = -1;
        }
    }

    public int getTotalHits() {
        return this.totalHits;
    }
}

