/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.dynaXML;

import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.cdlib.xtf.cache.FileDependency;
import org.cdlib.xtf.cache.GeneratingCache;
import org.cdlib.xtf.cache.StringCache;
import org.cdlib.xtf.dynaXML.DynaXML;
import org.cdlib.xtf.dynaXML.DynaXMLConfig;
import org.cdlib.xtf.dynaXML.DynaXMLException;
import org.cdlib.xtf.dynaXML.IpList;
import org.cdlib.xtf.dynaXML.NoPermissionException;
import org.cdlib.xtf.util.Base64;
import org.cdlib.xtf.util.EasyNode;
import org.cdlib.xtf.util.Trace;

class Authenticator {
    private SecureRandom secureRandom = new SecureRandom();
    private IpListCache ipListCache;
    private StringCache authCache;
    private StringCache loginCache;
    private DynaXML servlet;
    private DynaXMLConfig config;

    public Authenticator(DynaXML servlet) {
        this.servlet = servlet;
        this.config = (DynaXMLConfig)servlet.getConfig();
        this.authCache = new StringCache("AuthCache", this.config.authCacheSize, this.config.authCacheExpire);
        this.loginCache = new StringCache("LoginCache", this.config.loginCacheSize, this.config.loginCacheExpire);
        this.ipListCache = new IpListCache(this.config.ipListCacheSize, this.config.ipListCacheExpire, this.config.dependencyCheckingEnabled);
    }

    private boolean isEmpty(String s) {
        return s == null || s.equals("");
    }

    public AuthSpec processAuthTag(EasyNode el) throws DynaXMLException {
        AuthSpec spec = null;
        if (Trace.getOutputLevel() >= 8) {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < el.nAttrs()) {
                String name = el.attrName(i);
                buf.append(String.valueOf(name) + "=" + el.attrValue(i) + " ");
                ++i;
            }
            Trace.debug("Processing auth spec: " + buf.toString());
        }
        if (!el.hasAttr("type")) {
            throw new DynaXMLException("Auth type not specified by docReqParserSheet");
        }
        String type = el.attrValue("type");
        if (type.equals("all")) {
            spec = new AllAuthSpec();
            spec.type = 0;
        } else if (type.equals("IP")) {
            spec = new IPAuthSpec();
            spec.type = 1;
            if (!el.hasAttr("list")) {
                throw new DynaXMLException("Auth IP 'list' not specified by docReqParserSheet");
            }
            ((IPAuthSpec)spec).ipList = this.servlet.getRealPath(el.attrValue("list"));
        } else if (type.equals("LDAP")) {
            LdapAuthSpec lspec = new LdapAuthSpec();
            spec = lspec;
            spec.type = 2;
            lspec.realm = el.attrValue("realm");
            lspec.server = el.attrValue("server");
            lspec.bindName = el.attrValue("bindName");
            lspec.bindPassword = el.attrValue("bindPassword");
            lspec.queryName = el.attrValue("queryName");
            lspec.matchField = el.attrValue("matchField");
            lspec.matchValue = el.attrValue("matchValue");
            if (this.isEmpty(lspec.server)) {
                throw new DynaXMLException("LDAP server not specified by docReqParserSheet");
            }
            if (this.isEmpty(lspec.queryName)) {
                throw new DynaXMLException("LDAP queryName not specified by docReqParserSheet");
            }
            if (this.isEmpty(lspec.matchField) && !this.isEmpty(lspec.matchValue) || !this.isEmpty(lspec.matchField) && this.isEmpty(lspec.matchValue)) {
                throw new DynaXMLException("LDAP matchField and matchValue must be either both present or both absent in docReqParserSheet.");
            }
            if (this.isEmpty(lspec.bindName) && this.isEmpty(lspec.matchField)) {
                throw new DynaXMLException("Either LDAP bindName or matchField must be specified by docReqParserSheet.");
            }
        } else if (type.equals("external")) {
            ExternalAuthSpec espec = new ExternalAuthSpec();
            spec = espec;
            spec.type = 3;
            espec.url = el.attrValue("url");
            espec.secretKey = el.attrValue("key");
            if (this.isEmpty(espec.url)) {
                throw new DynaXMLException("External authorization page url not specified by docReqParserSheet");
            }
            if (this.isEmpty(espec.secretKey)) {
                throw new DynaXMLException("External authorization key (secret) not specified by docReqParserSheet");
            }
        } else {
            throw new DynaXMLException("Invalid auth type '" + type + "' specified by docReqParserSheet");
        }
        if (!el.hasAttr("access")) {
            throw new DynaXMLException("Auth access (allow or deny) must be specified by docReqParserSheet");
        }
        String access = el.attrValue("access");
        if (access.equals("allow")) {
            spec.access = 1;
        } else if (access.equals("deny")) {
            spec.access = 0;
        } else {
            throw new DynaXMLException("Invalid access '" + access + "' specified by docReqParser");
        }
        return spec;
    }

    public void clearCaches() {
        this.ipListCache.clear();
        this.authCache.clear();
        this.loginCache.clear();
    }

    private void authLdap(LdapAuthSpec spec, HttpServletRequest req, HttpServletResponse res) throws Exception {
        int spacePos;
        String realm;
        HttpSession session = req.getSession();
        String sessionID = req.getSession().getId();
        String authCacheKey = String.valueOf(sessionID) + ":LDAP" + ":" + spec.server + ":" + spec.bindName + ":" + spec.queryName + ":" + spec.matchField + ":" + spec.matchValue;
        if (this.authCache.has(authCacheKey)) {
            return;
        }
        String string = realm = this.isEmpty(spec.realm) ? "dynaXML" : spec.realm;
        if (session.getAttribute("LDAP_attempted") == null) {
            session.setAttribute("LDAP_attempted", (Object)new Boolean(true));
            Trace.debug("New session (" + session.getId() + ")... " + "forcing re-authentication");
            res.addHeader("WWW-Authenticate", "Basic realm=\"" + realm + "\"");
            res.setStatus(401);
            throw new NoPermissionException();
        }
        session.removeAttribute("LDAP_attempted");
        String userName = "";
        String password = "";
        String auth = req.getHeader("Authorization");
        if (auth != null && (spacePos = auth.indexOf(32)) >= 0) {
            String decoded;
            int colonPos;
            String method = auth.substring(0, spacePos);
            String stuff = auth.substring(spacePos + 1);
            if (method.equals("Basic") && (colonPos = (decoded = Base64.decodeString(stuff)).indexOf(58)) >= 0) {
                userName = decoded.substring(0, colonPos);
                password = decoded.substring(colonPos + 1);
            }
        }
        LdapAuthSpec oldSpec = spec;
        spec = new LdapAuthSpec();
        spec.realm = oldSpec.realm;
        spec.server = oldSpec.server;
        spec.bindName = oldSpec.bindName.replaceAll("\\%", userName);
        spec.bindPassword = oldSpec.bindPassword.replaceAll("\\%", password);
        spec.queryName = oldSpec.queryName.replaceAll("\\%", userName);
        spec.matchField = oldSpec.matchField;
        spec.matchValue = oldSpec.matchValue.replaceAll("\\%", password);
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", spec.server);
        env.put("java.naming.security.authentication", "simple");
        if (!this.isEmpty(spec.bindName)) {
            env.put("java.naming.security.principal", spec.bindName);
        }
        if (!this.isEmpty(spec.bindPassword)) {
            env.put("java.naming.security.credentials", spec.bindPassword);
        }
        try {
            InitialDirContext ctx = new InitialDirContext(env);
            Attributes attribs = ctx.getAttributes(spec.queryName);
            if (attribs.size() == 0) {
                throw new NoPermissionException();
            }
            if (!this.isEmpty(spec.matchField)) {
                Attribute attrib = attribs.get(spec.matchField);
                if (attrib == null) {
                    Trace.warning("[sensitive] LDAP: Cannot find field '" + spec.matchField + "'");
                    throw new NoPermissionException();
                }
                if (!attrib.contains(spec.matchValue)) {
                    Trace.warning("[sensitive] LDAP: Cannot match value '" + spec.matchValue + "' for field '" + spec.matchField + "'");
                    throw new NoPermissionException();
                }
            }
        }
        catch (Exception e) {
            Trace.warning("[sensitive] LDAP authentication failure: " + e.getClass().getName() + " - " + e.getMessage() + ". " + "server='" + spec.server + "', " + "bindName='" + spec.bindName + "', " + "bindPassword='" + spec.bindPassword + "', " + "queryName='" + spec.queryName + "', " + "matchField='" + spec.matchField + "', " + "matchValue='" + spec.matchValue + "'");
            res.addHeader("WWW-Authenticate", "Basic realm=\"" + realm + "\"");
            res.setStatus(401);
            session.setAttribute("LDAP_attempted", (Object)new Boolean(true));
            throw new NoPermissionException(e);
        }
        this.authCache.set(authCacheKey, "LDAP");
    }

    private boolean authExternal(ExternalAuthSpec spec, HttpServletRequest req, HttpServletResponse res) throws Exception {
        HttpSession session = req.getSession();
        String sessionID = req.getSession().getId();
        String authCacheKey = String.valueOf(sessionID) + ":ext:" + spec.url;
        if (this.authCache.has(authCacheKey)) {
            return true;
        }
        if (req.getParameter("hash") != null && req.getParameter("nonce") != null) {
            String nonce = req.getParameter("nonce");
            String hash = req.getParameter("hash");
            if (sessionID.equals(this.loginCache.get(nonce))) {
                this.loginCache.remove(nonce);
                String strToHash = String.valueOf(nonce) + ":" + spec.secretKey;
                MessageDigest digest = MessageDigest.getInstance("MD5");
                int i = 0;
                while (i < strToHash.length()) {
                    digest.update((byte)strToHash.charAt(i));
                    ++i;
                }
                String compHash = Authenticator.bytesToHex(digest.digest());
                if (compHash.equals(hash)) {
                    this.authCache.set(authCacheKey, "ext");
                    res.addHeader("Cache-Control", "no-cache");
                    res.sendRedirect((String)session.getAttribute("Ext_orig_url"));
                    res.addHeader("Cache-Control", "no-cache");
                    return false;
                }
                Trace.warning("Hash " + hash + " doesn't match calc'd " + compHash);
            } else if (this.loginCache.has(nonce)) {
                Trace.warning("Bad external session: " + this.loginCache.get(nonce) + " turned into " + sessionID);
                this.loginCache.remove(nonce);
            }
        }
        StringBuffer returnUrl = req.getRequestURL();
        Enumeration e = req.getParameterNames();
        boolean first = true;
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (name.equals("nonce") || name.equals("hash")) continue;
            returnUrl.append(first ? "?" : "&");
            returnUrl.append(String.valueOf(name) + "=" + req.getParameter(name));
            first = false;
        }
        session.setAttribute("Ext_orig_url", (Object)returnUrl.toString());
        byte[] bytes = new byte[16];
        this.secureRandom.nextBytes(bytes);
        String nonce = Authenticator.bytesToHex(bytes);
        this.loginCache.set(nonce, sessionID);
        StringBuffer finalUrl = new StringBuffer(spec.url);
        finalUrl.append("?returnto=" + URLEncoder.encode(returnUrl.toString(), "UTF-8"));
        finalUrl.append("&nonce=" + nonce);
        res.addHeader("Cache-Control", "no-cache");
        res.sendRedirect(finalUrl.toString());
        res.addHeader("Cache-Control", "no-cache");
        return false;
    }

    public boolean checkAuth(String ipAddr, Vector authSpecs, HttpServletRequest req, HttpServletResponse res) throws Exception {
        boolean allow = false;
        int i = 0;
        while (!allow && i < authSpecs.size()) {
            AuthSpec spec = (AuthSpec)authSpecs.get(i);
            switch (spec.type) {
                case 0: {
                    if (spec.access == 1) {
                        Trace.debug("Auth allow all");
                        allow = true;
                        break;
                    }
                    Trace.debug("Auth deny all");
                    throw new NoPermissionException(ipAddr);
                }
                case 1: {
                    IpList ipList = this.ipListCache.find(((IPAuthSpec)spec).ipList);
                    boolean onList = ipList.isApproved(ipAddr);
                    if (spec.access == 1) {
                        Trace.debug("Auth allow IP " + ipAddr + ": on-list=" + (onList ? "yes" : "no"));
                        if (!onList) break;
                        allow = true;
                        break;
                    }
                    Trace.debug("Auth deny IP " + ipAddr + ": on-list=" + (onList ? "yes" : "no"));
                    if (!onList) break;
                    throw new NoPermissionException(ipAddr);
                }
                case 2: {
                    if (spec.access == 0) {
                        throw new NoPermissionException(ipAddr);
                    }
                    this.authLdap((LdapAuthSpec)spec, req, res);
                    Trace.debug("Auth LDAP: ok");
                    allow = true;
                    break;
                }
                case 3: {
                    if (spec.access == 0) {
                        throw new NoPermissionException(ipAddr);
                    }
                    if (this.authExternal((ExternalAuthSpec)spec, req, res)) {
                        Trace.debug("Auth external: yes");
                        allow = true;
                        break;
                    }
                    Trace.debug("Auth external: no");
                    return false;
                }
                default: {
                    throw new DynaXMLException("Internal error");
                }
            }
            ++i;
        }
        if (!allow) {
            throw new NoPermissionException(ipAddr);
        }
        return true;
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < bytes.length) {
            int n = bytes[i] & 0xFF;
            if (n < 16) {
                buf.append("0");
            }
            buf.append(Integer.toHexString(n));
            ++i;
        }
        return buf.toString();
    }

    private class AllAuthSpec
    extends AuthSpec {
        private AllAuthSpec() {
        }
    }

    private class AuthSpec {
        public static final int ACCESS_DENY = 0;
        public static final int ACCESS_ALLOW = 1;
        public static final int TYPE_ALL = 0;
        public static final int TYPE_IP = 1;
        public static final int TYPE_LDAP = 2;
        public static final int TYPE_EXTERNAL = 3;
        int access;
        int type;

        private AuthSpec() {
        }
    }

    private class ExternalAuthSpec
    extends AuthSpec {
        String url;
        String secretKey;

        private ExternalAuthSpec() {
        }
    }

    private class IPAuthSpec
    extends AuthSpec {
        String ipList;

        private IPAuthSpec() {
        }
    }

    private class IpListCache
    extends GeneratingCache {
        private boolean dependencyChecking;

        public IpListCache(int maxEntries, int maxTime, boolean dependencyChecking) {
            super(maxEntries, maxTime);
            this.dependencyChecking = dependencyChecking;
        }

        public IpList find(String path) throws Exception {
            return (IpList)super.find(path);
        }

        protected Object generate(Object key) throws Exception {
            String path = (String)key;
            if (this.dependencyChecking) {
                this.addDependency(new FileDependency(path));
            }
            return new IpList(path);
        }

        protected void logAction(String action, Object key, Object value) {
            Trace.warning("IpListCache: " + action + ". Path=" + (String)key);
        }
    }

    private class LdapAuthSpec
    extends AuthSpec {
        String realm;
        String server;
        String bindName;
        String bindPassword;
        String queryName;
        String matchField;
        String matchValue;

        private LdapAuthSpec() {
        }
    }
}

