/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Arrays;
import junit.framework.TestCase;
import org.apache.lucene.util.StringUtil;

public class StringUtilTest
extends TestCase {
    public void testJoin() {
        Object[] array = new String[]{"abc", "def", "ghi"};
        StringUtilTest.assertEquals((String)StringUtil.join(array), (String)"abc def ghi");
        StringUtilTest.assertEquals((String)StringUtil.join(array, " -> "), (String)"abc -> def -> ghi");
        StringUtilTest.assertEquals((String)StringUtil.join(new String[0]), (String)"");
        StringUtilTest.assertEquals((String)StringUtil.join(null), null);
    }

    public void testPad() {
        StringUtilTest.assertEquals((String)StringUtil.padEnd("foo", 3), (String)"foo");
        StringUtilTest.assertEquals((String)StringUtil.padEnd("foo", 5), (String)"foo  ");
        StringUtilTest.assertEquals((String)StringUtil.padEnd("foo", 5, 'x'), (String)"fooxx");
        StringUtilTest.assertEquals((String)StringUtil.justifyLeft("foo", 3), (String)"foo");
        StringUtilTest.assertEquals((String)StringUtil.justifyLeft("foo", 5), (String)"foo  ");
        StringUtilTest.assertEquals((String)StringUtil.padStart("foo", 3), (String)"foo");
        StringUtilTest.assertEquals((String)StringUtil.padStart("foo", 5), (String)"  foo");
        StringUtilTest.assertEquals((String)StringUtil.padStart("foo", 5, 'x'), (String)"xxfoo");
        StringUtilTest.assertEquals((String)StringUtil.justifyRight("foo", 3), (String)"foo");
        StringUtilTest.assertEquals((String)StringUtil.justifyRight("foo", 5), (String)"  foo");
    }

    public void testCase() {
        StringUtilTest.assertTrue((boolean)StringUtil.isUpperCase("ABC"));
        StringUtilTest.assertTrue((boolean)StringUtil.isUpperCase("X"));
        StringUtilTest.assertFalse((boolean)StringUtil.isUpperCase("abc"));
        StringUtilTest.assertFalse((boolean)StringUtil.isUpperCase("Abc"));
        StringUtilTest.assertFalse((boolean)StringUtil.isUpperCase("1"));
        StringUtilTest.assertFalse((boolean)StringUtil.isUpperCase(""));
        StringUtilTest.assertTrue((boolean)StringUtil.isLowerCase("abc"));
        StringUtilTest.assertTrue((boolean)StringUtil.isLowerCase("x"));
        StringUtilTest.assertFalse((boolean)StringUtil.isLowerCase("ABC"));
        StringUtilTest.assertFalse((boolean)StringUtil.isLowerCase("aBC"));
        StringUtilTest.assertFalse((boolean)StringUtil.isLowerCase("1"));
        StringUtilTest.assertFalse((boolean)StringUtil.isLowerCase(""));
        StringUtilTest.assertTrue((boolean)StringUtil.isTitleCase("Abc"));
        StringUtilTest.assertFalse((boolean)StringUtil.isTitleCase("abc"));
        StringUtilTest.assertFalse((boolean)StringUtil.isTitleCase("ABC"));
        StringUtilTest.assertFalse((boolean)StringUtil.isTitleCase("X"));
        StringUtilTest.assertFalse((boolean)StringUtil.isTitleCase("x"));
        StringUtilTest.assertFalse((boolean)StringUtil.isTitleCase("1"));
        StringUtilTest.assertFalse((boolean)StringUtil.isLowerCase(""));
        StringUtilTest.assertTrue((boolean)StringUtil.isTitleCase("Abc Def"));
        StringUtilTest.assertFalse((boolean)StringUtil.isTitleCase("Abc def"));
        StringUtilTest.assertFalse((boolean)StringUtil.isTitleCase("abc Def"));
        StringUtilTest.assertEquals((String)StringUtil.toTitleCase("Abc"), (String)"Abc");
        StringUtilTest.assertEquals((String)StringUtil.toTitleCase("ABC"), (String)"Abc");
        StringUtilTest.assertEquals((String)StringUtil.toTitleCase("abc"), (String)"Abc");
        StringUtilTest.assertEquals((String)StringUtil.toTitleCase("x"), (String)"X");
        StringUtilTest.assertEquals((String)StringUtil.toTitleCase("X"), (String)"X");
        StringUtilTest.assertEquals((String)StringUtil.toTitleCase("1"), (String)"1");
        StringUtilTest.assertEquals((String)StringUtil.toTitleCase("Abc Def"), (String)"Abc Def");
        StringUtilTest.assertEquals((String)StringUtil.toTitleCase("ABC def"), (String)"Abc Def");
        StringUtilTest.assertEquals((String)StringUtil.toTitleCase("abc DEF"), (String)"Abc Def");
        StringUtilTest.assertEquals((String)StringUtil.copyCase("Abc", "Xyz"), (String)"Xyz");
        StringUtilTest.assertEquals((String)StringUtil.copyCase("Abc", "xyz"), (String)"Xyz");
        StringUtilTest.assertEquals((String)StringUtil.copyCase("Abc", "XYZ"), (String)"Xyz");
        StringUtilTest.assertEquals((String)StringUtil.copyCase("ABC", "Xyz"), (String)"XYZ");
        StringUtilTest.assertEquals((String)StringUtil.copyCase("ABC", "xyz"), (String)"XYZ");
        StringUtilTest.assertEquals((String)StringUtil.copyCase("ABC", "XYZ"), (String)"XYZ");
        StringUtilTest.assertEquals((String)StringUtil.copyCase("abc", "Xyz"), (String)"xyz");
        StringUtilTest.assertEquals((String)StringUtil.copyCase("abc", "xyz"), (String)"xyz");
        StringUtilTest.assertEquals((String)StringUtil.copyCase("abc", "XYZ"), (String)"xyz");
        StringUtilTest.assertEquals((String)StringUtil.copyCase("1", "Xyz"), (String)"Xyz");
        StringUtilTest.assertEquals((String)StringUtil.copyCase("1", "xyz"), (String)"xyz");
        StringUtilTest.assertEquals((String)StringUtil.copyCase("1", "XYZ"), (String)"XYZ");
        StringUtilTest.assertEquals((String)StringUtil.copyCase("abc Def", "Xyz"), (String)"Xyz");
        StringUtilTest.assertEquals((String)StringUtil.copyCase("abc Def", "xyz"), (String)"xyz");
        StringUtilTest.assertEquals((String)StringUtil.copyCase("abc Def", "XYZ"), (String)"XYZ");
    }

    public void testSplitWords() {
        StringUtilTest.assertTrue((boolean)Arrays.deepEquals(StringUtil.splitWords("abc def ghi"), new String[]{"abc", "def", "ghi"}));
        StringUtilTest.assertTrue((boolean)Arrays.deepEquals(StringUtil.splitWords("a b c"), new String[]{"a", "b", "c"}));
        StringUtilTest.assertTrue((boolean)Arrays.deepEquals(StringUtil.splitWords("abc"), new String[]{"abc"}));
        StringUtilTest.assertTrue((boolean)Arrays.deepEquals(StringUtil.splitWords(""), new String[0]));
        StringUtilTest.assertTrue((boolean)Arrays.deepEquals(StringUtil.splitWords(null), new String[0]));
    }

    public void testHtml() {
        StringUtilTest.assertEquals((String)"This &lt;tag&gt; is &quot;great&quot; and it&apos;s cool!", (String)StringUtil.escapeHTMLChars("This <tag> is \"great\" and it's cool!"));
    }
}

