/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.regex.Pattern;

public class StringUtil {
    private static final Pattern spacePat = Pattern.compile("\\s+");

    public static String join(Object[] in) {
        return StringUtil.join(in, " ");
    }

    public static String join(Object[] in, String separator) {
        if (in == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < in.length) {
            if (in[i] != null) {
                if (i > 0) {
                    buf.append(separator);
                }
                buf.append(in[i].toString());
            }
            ++i;
        }
        return buf.toString();
    }

    public static String padEnd(String in, int len) {
        return StringUtil.padEnd(in, len, ' ');
    }

    public static String justifyLeft(String in, int len) {
        return StringUtil.padEnd(in, len, ' ');
    }

    public static String padEnd(String in, int len, char padChar) {
        if (in.length() >= len) {
            return in;
        }
        StringBuffer buf = new StringBuffer(len);
        buf.append(in);
        int i = 0;
        while (i < len - in.length()) {
            buf.append(padChar);
            ++i;
        }
        return buf.toString();
    }

    public static String padStart(String in, int len) {
        return StringUtil.padStart(in, len, ' ');
    }

    public static String justifyRight(String in, int len) {
        return StringUtil.padStart(in, len, ' ');
    }

    public static String padStart(String in, int len, char padChar) {
        if (in.length() >= len) {
            return in;
        }
        StringBuffer buf = new StringBuffer(len);
        int i = 0;
        while (i < len - in.length()) {
            buf.append(padChar);
            ++i;
        }
        buf.append(in);
        return buf.toString();
    }

    public static String copyCase(String pattern, String in) {
        if (StringUtil.isLowerCase(pattern)) {
            return in.toLowerCase();
        }
        if (StringUtil.isUpperCase(pattern)) {
            return in.toUpperCase();
        }
        if (StringUtil.isTitleCase(pattern)) {
            return StringUtil.toTitleCase(in);
        }
        return in;
    }

    public static boolean isUpperCase(String in) {
        if (in == null || in.length() == 0) {
            return false;
        }
        int i = 0;
        while (i < in.length()) {
            if (!Character.isUpperCase(in.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isLowerCase(String in) {
        if (in == null || in.length() == 0) {
            return false;
        }
        int i = 0;
        while (i < in.length()) {
            if (!Character.isLowerCase(in.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isTitleCase(String in) {
        if (in == null || in.length() == 0) {
            return false;
        }
        String[] words = StringUtil.splitWords(in);
        if (words.length == 1) {
            String word = words[0];
            if (word.length() <= 1) {
                return false;
            }
            return Character.isUpperCase(word.charAt(0)) && StringUtil.isLowerCase(word.substring(1));
        }
        int i = 0;
        while (i < words.length) {
            if (!StringUtil.isTitleCase(words[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String toTitleCase(String in) {
        String[] words = StringUtil.splitWords(in);
        if (words.length == 0) {
            return in;
        }
        if (words.length == 1) {
            String word = words[0];
            if (word.length() < 1) {
                return word;
            }
            return String.valueOf(Character.toUpperCase(word.charAt(0))) + word.substring(1).toLowerCase();
        }
        Object[] converted = new String[words.length];
        int i = 0;
        while (i < words.length) {
            converted[i] = StringUtil.toTitleCase(words[i]);
            ++i;
        }
        return StringUtil.join(converted);
    }

    public static String[] splitWords(String in) {
        if (in == null) {
            return new String[0];
        }
        String trimmed = in.trim();
        if (trimmed.length() == 0) {
            return new String[0];
        }
        return spacePat.split(trimmed);
    }

    public static String escapeHTMLChars(String in) {
        StringBuffer buf = new StringBuffer(in.length());
        int i = 0;
        while (i < in.length()) {
            char c = in.charAt(i);
            if (c < '\u0000' || c > '\u001f' || c == '\t' || c == '\u000b' || c == '\r') {
                switch (c) {
                    case '<': {
                        buf.append("&lt;");
                        break;
                    }
                    case '>': {
                        buf.append("&gt;");
                        break;
                    }
                    case '&': {
                        buf.append("&amp;");
                        break;
                    }
                    case '\'': {
                        buf.append("&apos;");
                        break;
                    }
                    case '\"': {
                        buf.append("&quot;");
                        break;
                    }
                    case '\n': {
                        buf.append("<br/>\n");
                        break;
                    }
                    case '\u0080': {
                        buf.append("\u20ac");
                        break;
                    }
                    case '\u0081': {
                        buf.append("\u0081");
                        break;
                    }
                    case '\u0082': {
                        buf.append("\u201a");
                        break;
                    }
                    case '\u0083': {
                        buf.append("\u0192");
                        break;
                    }
                    case '\u0084': {
                        buf.append("\u201e");
                        break;
                    }
                    case '\u0085': {
                        buf.append("\u2026");
                        break;
                    }
                    case '\u0086': {
                        buf.append("\u2020");
                        break;
                    }
                    case '\u0087': {
                        buf.append("\u2021");
                        break;
                    }
                    case '\u0088': {
                        buf.append("\u02c6");
                        break;
                    }
                    case '\u0089': {
                        buf.append("\u2030");
                        break;
                    }
                    case '\u008a': {
                        buf.append("\u0160");
                        break;
                    }
                    case '\u008b': {
                        buf.append("\u2039");
                        break;
                    }
                    case '\u008c': {
                        buf.append("\u0152");
                        break;
                    }
                    case '\u008d': {
                        buf.append("\u008d");
                        break;
                    }
                    case '\u008e': {
                        buf.append("\u017d");
                        break;
                    }
                    case '\u008f': {
                        buf.append("\u008f");
                        break;
                    }
                    case '\u0090': {
                        buf.append("\u0090");
                        break;
                    }
                    case '\u0091': {
                        buf.append("\u2018");
                        break;
                    }
                    case '\u0092': {
                        buf.append("\u2019");
                        break;
                    }
                    case '\u0093': {
                        buf.append("\u201c");
                        break;
                    }
                    case '\u0094': {
                        buf.append("\u201d");
                        break;
                    }
                    case '\u0095': {
                        buf.append("\u2022");
                        break;
                    }
                    case '\u0096': {
                        buf.append("\u2013");
                        break;
                    }
                    case '\u0097': {
                        buf.append("\u2014");
                        break;
                    }
                    case '\u0098': {
                        buf.append("\u02dc");
                        break;
                    }
                    case '\u0099': {
                        buf.append("\u2122");
                        break;
                    }
                    case '\u009a': {
                        buf.append("\u0161");
                        break;
                    }
                    case '\u009b': {
                        buf.append("\u203a");
                        break;
                    }
                    case '\u009c': {
                        buf.append("\u0153");
                        break;
                    }
                    case '\u009d': {
                        buf.append("\u009d");
                        break;
                    }
                    case '\u009e': {
                        buf.append("\u017e");
                        break;
                    }
                    case '\u009f': {
                        buf.append("\u0178");
                        break;
                    }
                    default: {
                        buf.append(c);
                    }
                }
            }
            ++i;
        }
        return buf.toString();
    }
}

