/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.xml;

import com.topologi.diffx.xml.XMLWriter;
import com.topologi.diffx.xml.esc.XMLEscapeWriter;
import com.topologi.diffx.xml.esc.XMLEscapeWriterUTF8;
import java.io.IOException;
import java.io.Writer;

abstract class XMLWriterBase
implements XMLWriter {
    final boolean indent;
    final Writer writer;
    static final String ENCODING = "utf-8";
    final XMLEscapeWriter writerEscape;
    int depth = 0;

    public XMLWriterBase(Writer writer) throws NullPointerException {
        this(writer, true);
    }

    public XMLWriterBase(Writer writer, boolean bl) throws NullPointerException {
        if (writer == null) {
            throw new NullPointerException("XMLWriter cannot use a null writer.");
        }
        this.writer = writer;
        this.writerEscape = new XMLEscapeWriterUTF8(writer);
        this.indent = bl;
    }

    public final void xmlDecl() throws IOException {
        this.writer.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
    }

    public void writeText(String string) throws IOException {
        this.writerEscape.writeText(string);
    }

    public void writeText(char[] cArray, int n, int n2) throws IOException {
        for (int i = n; i < n + n2; ++i) {
            this.writeChar(cArray[i]);
        }
    }

    public void writeXML(String string) throws IOException {
        this.writer.write(string);
    }

    public void writeXML(char[] cArray, int n, int n2) throws IOException {
        this.writer.write(cArray, n, n2);
    }

    public void writeChar(char c) throws IOException {
        this.writerEscape.writeText(c);
    }

    public final void writeText(Object object) throws IOException {
        if (object != null) {
            this.writeText(object.toString());
        }
    }

    public void writeComment(String string) throws IOException, IllegalArgumentException {
        if (string != null && string.indexOf("--") >= 0) {
            throw new IllegalArgumentException("A comment should not contain '--'.");
        }
        this.writer.write("<!-- ");
        this.writer.write(string);
        this.writer.write(" -->");
        if (this.indent) {
            this.writer.write(10);
        }
    }

    public void writePI(String string, String string2) throws IOException {
        this.writer.write("<?");
        this.writer.write(string);
        this.writer.write(32);
        this.writer.write(string2);
        this.writer.write("?>");
        if (this.indent) {
            this.writer.write(10);
        }
    }

    void indent() throws IOException {
        if (this.indent) {
            for (int i = 0; i < this.depth; ++i) {
                this.writer.write("  ");
            }
        }
    }

    public void element(String string, String string2) throws IOException {
        this.openElement(string);
        this.writeText(string2);
        this.closeElement();
    }

    public final void write(String string) throws IOException {
        this.writer.write(string);
    }

    public final void write(char c) throws IOException {
        this.writer.write(c);
    }

    public final void flush() throws IOException {
        this.writer.flush();
    }

    public final void close() throws IOException {
        this.writer.close();
    }

    static final void doNothing() {
    }
}

