/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.bind.EntityBinding;
import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.bind.serial.TupleSerialMarshalledBinding;
import com.sleepycat.bind.serial.TupleSerialMarshalledKeyCreator;
import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleMarshalledBinding;
import com.sleepycat.collections.StoredMap;
import com.sleepycat.collections.StoredSortedMap;
import com.sleepycat.db.Database;

public class TupleSerialFactory {
    private ClassCatalog catalog;

    public TupleSerialFactory(ClassCatalog catalog) {
        this.catalog = catalog;
    }

    public final ClassCatalog getCatalog() {
        return this.catalog;
    }

    public StoredMap newMap(Database db, Class keyClass, Class valueBaseClass, boolean writeAllowed) {
        return new StoredMap(db, this.getKeyBinding(keyClass), (EntityBinding)this.getEntityBinding(valueBaseClass), writeAllowed);
    }

    public StoredSortedMap newSortedMap(Database db, Class keyClass, Class valueBaseClass, boolean writeAllowed) {
        return new StoredSortedMap(db, this.getKeyBinding(keyClass), (EntityBinding)this.getEntityBinding(valueBaseClass), writeAllowed);
    }

    public TupleSerialMarshalledKeyCreator getKeyCreator(Class valueBaseClass, String keyName) {
        return new TupleSerialMarshalledKeyCreator(this.getEntityBinding(valueBaseClass), keyName);
    }

    private TupleSerialMarshalledBinding getEntityBinding(Class baseClass) {
        return new TupleSerialMarshalledBinding(this.catalog, baseClass);
    }

    private EntryBinding getKeyBinding(Class keyClass) {
        TupleBinding binding = TupleBinding.getPrimitiveBinding(keyClass);
        if (binding == null) {
            binding = new TupleMarshalledBinding(keyClass);
        }
        return binding;
    }
}

