/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.update;

import org.apache.log4j.Logger;
import org.exist.EXistException;
import org.exist.dom.AttrImpl;
import org.exist.dom.DocumentImpl;
import org.exist.dom.ElementImpl;
import org.exist.dom.NodeListImpl;
import org.exist.dom.StoredNode;
import org.exist.dom.TextImpl;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.NotificationService;
import org.exist.storage.txn.Txn;
import org.exist.util.LockException;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XPathUtil;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.update.Modification;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.util.Messages;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;

public class Update
extends Modification {
    private static final Logger LOG = Logger.getLogger((Class)Update.class);

    public Update(XQueryContext context, Expression select, Expression value) {
        super(context, select, value);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence contentSeq;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        if ((contentSeq = this.value.eval(contextSequence)).isEmpty()) {
            throw new XPathException(this.getASTNode(), Messages.getMessage("D09"));
        }
        Sequence inSeq = this.select.eval(contextSequence);
        if (!Type.subTypeOf(inSeq.getItemType(), -1)) {
            ValueSequence prevUpdateErrors = null;
            XPathException xpe = new XPathException(this.getASTNode(), Messages.getMessage("D08"));
            Object ctxVarObj = this.context.getXQueryContextVar("_eXist_xquery_update_error");
            prevUpdateErrors = ctxVarObj == null ? new ValueSequence() : (ValueSequence)XPathUtil.javaObjectToXPath(ctxVarObj, this.context);
            prevUpdateErrors.add(new StringValue(xpe.getMessage()));
            this.context.setXQueryContextVar("_eXist_xquery_update_error", prevUpdateErrors);
            if (!inSeq.isEmpty()) {
                throw xpe;
            }
        }
        if (!inSeq.isEmpty()) {
            this.context.pushInScopeNamespaces();
            try {
                NotificationService notifier = this.context.getBroker().getBrokerPool().getNotificationService();
                Txn transaction = this.getTransaction();
                StoredNode[] ql = this.selectAndLock(transaction, inSeq.toNodeSet());
                Modification.IndexListener listener = new Modification.IndexListener(ql);
                for (int i = 0; i < ql.length; ++i) {
                    StoredNode node = ql[i];
                    DocumentImpl doc = (DocumentImpl)node.getOwnerDocument();
                    if (!doc.getPermissions().validate(this.context.getUser(), 1)) {
                        throw new XPathException(this.getASTNode(), "permission to update document denied");
                    }
                    doc.getMetadata().setIndexListener(listener);
                    switch (node.getNodeType()) {
                        case 1: {
                            TextImpl text;
                            NodeListImpl content = new NodeListImpl();
                            SequenceIterator j = contentSeq.iterate();
                            while (j.hasNext()) {
                                Item next = j.nextItem();
                                if (Type.subTypeOf(next.getType(), -1)) {
                                    content.add(((NodeValue)next).getNode());
                                    continue;
                                }
                                text = new TextImpl(next.getStringValue());
                                content.add(text);
                            }
                            ((ElementImpl)node).update(transaction, content);
                            break;
                        }
                        case 3: {
                            ElementImpl parent = (ElementImpl)node.getParentNode();
                            TextImpl text = new TextImpl(contentSeq.getStringValue());
                            text.setOwnerDocument(doc);
                            parent.updateChild(transaction, node, text);
                            break;
                        }
                        case 2: {
                            ElementImpl parent = (ElementImpl)node.getParentNode();
                            if (parent == null) {
                                LOG.warn((Object)("parent node not found for " + node.getNodeId()));
                                break;
                            }
                            AttrImpl attr = (AttrImpl)node;
                            AttrImpl attribute = new AttrImpl(attr.getQName(), contentSeq.getStringValue());
                            attribute.setOwnerDocument(doc);
                            parent.updateChild(transaction, node, attribute);
                            break;
                        }
                        default: {
                            throw new XPathException(this.getASTNode(), "unsupported node-type");
                        }
                    }
                    doc.getMetadata().clearIndexListener();
                    doc.getMetadata().setLastModified(System.currentTimeMillis());
                    this.modifiedDocuments.add(doc);
                    this.context.getBroker().storeXMLResource(transaction, doc);
                    notifier.notifyUpdate(doc, 1);
                }
                this.checkFragmentation(transaction, this.modifiedDocuments);
                this.finishTriggers(transaction);
                this.commitTransaction(transaction);
            }
            catch (LockException e) {
                throw new XPathException(this.getASTNode(), e.getMessage(), e);
            }
            catch (PermissionDeniedException e) {
                throw new XPathException(this.getASTNode(), e.getMessage(), e);
            }
            catch (EXistException e) {
                throw new XPathException(this.getASTNode(), e.getMessage(), e);
            }
            finally {
                this.unlockDocuments();
                this.context.popInScopeNamespaces();
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", Sequence.EMPTY_SEQUENCE);
        }
        return Sequence.EMPTY_SEQUENCE;
    }

    public void dump(ExpressionDumper dumper) {
        dumper.display("update value").nl();
        dumper.startIndent();
        this.select.dump(dumper);
        dumper.nl().endIndent().display("with").nl().startIndent();
        this.value.dump(dumper);
        dumper.nl().endIndent();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("update value");
        result.append(this.select.toString());
        result.append(" with ");
        result.append(this.value.toString());
        return result.toString();
    }
}

