/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import org.exist.dom.DocumentImpl;
import org.exist.dom.QName;
import org.exist.util.MimeTable;
import org.exist.util.MimeType;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class XMLDBGetMimeType
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("get-mime-type", "http://exist-db.org/xquery/xmldb", "xmldb"), "Returns the MIME Type of the resource indicated in $a or an empty sequence otherwise.", new SequenceType[]{new SequenceType(25, 2)}, new SequenceType(22, 3));

    public XMLDBGetMimeType(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        String path = new AnyURIValue(args[0].itemAt(0).getStringValue()).toString();
        if (path.matches("^[a-z]+://.*")) {
            MimeTable mimeTable = MimeTable.getInstance();
            MimeType mimeType = mimeTable.getContentTypeFor(path);
            if (mimeType != null) {
                return new StringValue(mimeType.getName());
            }
        } else {
            DocumentImpl doc = null;
            try {
                XmldbURI pathUri = XmldbURI.xmldbUriFor(path);
                pathUri = this.context.getBaseURI().toXmldbURI().resolveCollectionPath(pathUri);
                doc = this.context.getBroker().getXMLResource(pathUri, 0);
                if (doc != null) {
                    StringValue stringValue = new StringValue(doc.getMetadata().getMimeType());
                    return stringValue;
                }
            }
            catch (Exception e) {
                throw new XPathException(e);
            }
            finally {
                if (doc != null) {
                    doc.getUpdateLock().release(0);
                }
            }
        }
        return Sequence.EMPTY_SEQUENCE;
    }
}

