/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import java.util.HashMap;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.dom.NodeSetIterator;
import org.exist.dom.QName;
import org.exist.memtree.ElementImpl;
import org.exist.memtree.NodeImpl;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.FunInScopePrefixes;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class FunNamespaceURIForPrefix
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("namespace-uri-for-prefix", "http://www.w3.org/2005/xpath-functions"), "Returns the namespace URI of one of the in-scope namespaces for $b, identified by its namespace prefix. If $b has an in-scope namespace whose namespace prefix is equal to $a, it returns the namespace URI of that namespace. If $b is the zero-length string or the empty sequence, it returns the namespace URI of the default (unnamed) namespace. Otherwise, it returns the empty sequence.", new SequenceType[]{new SequenceType(22, 3), new SequenceType(1, 2)}, new SequenceType(25, 3));

    public FunNamespaceURIForPrefix(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        String namespace;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
        }
        String prefix = args[0].isEmpty() ? "" : args[0].itemAt(0).getStringValue();
        NodeValue node = (NodeValue)args[1].itemAt(0);
        HashMap prefixes = new HashMap();
        if (node.getImplementationType() == 1) {
            NodeProxy proxy = (NodeProxy)node;
            NodeSet ancestors = proxy.getAncestors(this.contextId, true);
            NodeSetIterator i = ancestors.iterator();
            while (i.hasNext()) {
                proxy = (NodeProxy)i.next();
                FunInScopePrefixes.collectNamespacePrefixes((org.exist.dom.ElementImpl)proxy.getNode(), prefixes);
            }
        } else {
            NodeImpl next = (NodeImpl)node;
            do {
                FunInScopePrefixes.collectNamespacePrefixes((ElementImpl)next, prefixes);
            } while ((next = (NodeImpl)next.getParentNode()) != null && next.getNodeType() == 1);
        }
        Sequence result = (namespace = (String)prefixes.get(prefix)) == null ? Sequence.EMPTY_SEQUENCE : new AnyURIValue(namespace);
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

