/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.dom.ExtArrayNodeSet;
import org.exist.dom.NodeProxy;
import org.exist.dom.QName;
import org.exist.dom.StoredNode;
import org.exist.numbering.NodeId;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.UpdateListener;
import org.exist.util.LockException;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;

public class ExtDocument
extends Function {
    public static final FunctionSignature signature = new FunctionSignature(new QName("document", "http://www.w3.org/2005/xpath-functions"), "Returns the documents specified in the input sequence. This function is specific to eXist and will be replaced with the corresponding fn:doc function. The arguments are either document pathes like '/db/shakespeare/plays/hamlet.xml' or XMLDB URIs like 'xmldb:exist://localhost:8081//db/shakespeare/plays/hamlet.xml'. If the input sequence is empty, the function will load all documents in the database.", new SequenceType[]{new SequenceType(22, 6)}, new SequenceType(-1, 7), true, "Moved to the 'http://exist-db.org/xquery/xmldb' namespace since it conflicts with the XSLT 2.0 function.");
    private List cachedArgs = null;
    private Sequence cached = null;
    private DocumentSet cachedDocs = null;
    private UpdateListener listener = null;

    public ExtDocument(XQueryContext context) {
        super(context, signature);
    }

    public int getDependencies() {
        return 1;
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        DocumentSet docs = null;
        Sequence result = null;
        boolean lockOnLoad = this.context.lockDocumentsOnLoad();
        boolean cacheIsValid = false;
        if (this.getArgumentCount() == 0) {
            if (this.cached != null) {
                result = this.cached;
                docs = this.cachedDocs;
            } else {
                docs = new DocumentSet();
                this.context.getBroker().getAllXMLResources(docs);
            }
        } else {
            List args = this.getParameterValues(contextSequence, contextItem);
            if (this.cachedArgs != null) {
                cacheIsValid = this.compareArguments(this.cachedArgs, args);
            }
            if (cacheIsValid) {
                result = this.cached;
                docs = this.cachedDocs;
            } else {
                docs = new DocumentSet();
                for (int i = 0; i < args.size(); ++i) {
                    try {
                        DocumentImpl doc;
                        String next = (String)args.get(i);
                        XmldbURI nextUri = new AnyURIValue(next).toXmldbURI();
                        if (nextUri.getCollectionPath().length() == 0) {
                            throw new XPathException("Invalid argument to fn:doc function: empty string is not allowed here.");
                        }
                        if (nextUri.numSegments() == 1) {
                            nextUri = this.context.getBaseURI().toXmldbURI().resolveCollectionPath(nextUri);
                        }
                        if ((doc = (DocumentImpl)this.context.getBroker().getXMLResource(nextUri)) == null) continue;
                        if (!doc.getPermissions().validate(this.context.getUser(), 4)) {
                            throw new XPathException("Insufficient privileges to read resource " + next);
                        }
                        docs.add(doc);
                        continue;
                    }
                    catch (XPathException e) {
                        e.setASTNode(this.getASTNode());
                        throw e;
                    }
                    catch (PermissionDeniedException e) {
                        throw new XPathException("Permission denied: unable to load document " + (String)args.get(i));
                    }
                }
                this.cachedArgs = args;
            }
        }
        try {
            if (!cacheIsValid) {
                docs.lock(this.context.getBroker(), lockOnLoad, true);
            }
            if (result == null) {
                result = new ExtArrayNodeSet(docs.getLength(), 1);
                Iterator i = docs.iterator();
                while (i.hasNext()) {
                    DocumentImpl doc = (DocumentImpl)i.next();
                    result.add(new NodeProxy(doc));
                    if (!lockOnLoad) continue;
                    this.context.addLockedDocument(doc);
                }
            }
        }
        catch (LockException e) {
            throw new XPathException(this.getASTNode(), "Could not acquire lock on document set.");
        }
        finally {
            if (!cacheIsValid && !lockOnLoad) {
                docs.unlock(lockOnLoad);
            }
        }
        this.cached = result;
        this.cachedDocs = docs;
        this.registerUpdateListener();
        return result;
    }

    private List getParameterValues(Sequence contextSequence, Item contextItem) throws XPathException {
        ArrayList<String> args = new ArrayList<String>(this.getArgumentCount() + 10);
        for (int i = 0; i < this.getArgumentCount(); ++i) {
            Sequence seq = this.getArgument(i).eval(contextSequence, contextItem);
            SequenceIterator j = seq.iterate();
            while (j.hasNext()) {
                Item next = j.nextItem();
                args.add(next.getStringValue());
            }
        }
        return args;
    }

    private boolean compareArguments(List args1, List args2) {
        if (args1.size() != args2.size()) {
            return false;
        }
        for (int i = 0; i < args1.size(); ++i) {
            String arg2;
            String arg1 = (String)args1.get(i);
            if (arg1.equals(arg2 = (String)args2.get(i))) continue;
            return false;
        }
        return true;
    }

    protected void registerUpdateListener() {
        if (this.listener == null) {
            this.listener = new UpdateListener(){

                public void documentUpdated(DocumentImpl document, int event) {
                    if (document == null || event == 0 || event == 2) {
                        ExtDocument.this.cachedArgs = null;
                        ExtDocument.this.cached = null;
                        ExtDocument.this.cachedDocs = null;
                    } else if (ExtDocument.this.cachedDocs != null && ExtDocument.this.cachedDocs.contains(document.getDocId())) {
                        ExtDocument.this.cachedDocs = null;
                        ExtDocument.this.cached = null;
                        ExtDocument.this.cachedArgs = null;
                    }
                }

                public void unsubscribe() {
                    ExtDocument.this.listener = null;
                }

                public void nodeMoved(NodeId oldNodeId, StoredNode newNode) {
                }

                public void debug() {
                    LOG.debug((Object)("UpdateListener: Line: " + ExtDocument.this.getASTNode().getLine() + ": " + ExtDocument.this.toString()));
                }
            };
            this.context.registerUpdateListener(this.listener);
        }
    }

    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        if (!postOptimization) {
            this.cached = null;
            this.cachedArgs = null;
            this.cachedDocs = null;
            this.listener = null;
        }
    }
}

