/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.text.Collator;
import org.exist.dom.ContextItem;
import org.exist.dom.ExtArrayNodeSet;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.dom.NodeSetIterator;
import org.exist.xquery.Constants;
import org.exist.xquery.Expression;
import org.exist.xquery.GeneralComparison;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.Type;

public class ValueComparison
extends GeneralComparison {
    public ValueComparison(XQueryContext context, int relation) {
        super(context, relation);
    }

    public ValueComparison(XQueryContext context, Expression left, Expression right, int relation) {
        super(context, left, right, relation);
    }

    protected Sequence genericCompare(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().message((Expression)this, Profiler.OPTIMIZATION_FLAGS, "OPTIMIZATION CHOICE", "genericCompare");
        }
        Sequence ls = this.getLeft().eval(contextSequence, contextItem);
        Sequence rs = this.getRight().eval(contextSequence, contextItem);
        if (ls.isEmpty() || rs.isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        if (ls.hasOne() && rs.hasOne()) {
            AtomicValue lv = ls.itemAt(0).atomize();
            AtomicValue rv = rs.itemAt(0).atomize();
            Collator collator = this.getCollator(contextSequence);
            return BooleanValue.valueOf(ValueComparison.compareAtomic(collator, lv, rv, -1, this.relation));
        }
        throw new XPathException(this.getASTNode(), "Type error: sequence with more than one item is not allowed here");
    }

    protected Sequence nodeSetCompare(NodeSet nodes, Sequence contextSequence) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().message((Expression)this, Profiler.OPTIMIZATION_FLAGS, "OPTIMIZATION CHOICE", "nodeSetCompare");
        }
        ExtArrayNodeSet result = new ExtArrayNodeSet();
        Collator collator = this.getCollator(contextSequence);
        if (contextSequence != null && !contextSequence.isEmpty()) {
            NodeSetIterator i = nodes.iterator();
            while (i.hasNext()) {
                NodeProxy current = (NodeProxy)i.next();
                ContextItem context = current.getContext();
                if (context == null) {
                    throw new XPathException(this.getASTNode(), "Context is missing for node set comparison");
                }
                do {
                    AtomicValue lv = current.atomize();
                    Sequence rs = this.getRight().eval(context.getNode().toSequence());
                    if (!rs.hasOne()) {
                        throw new XPathException(this.getASTNode(), "Type error: sequence with less or more than one item is not allowed here");
                    }
                    if (!ValueComparison.compareAtomic(collator, lv, rs.itemAt(0).atomize(), -1, this.relation)) continue;
                    result.add(current);
                } while ((context = context.getNextDirect()) != null);
            }
        } else {
            Sequence rs = this.getRight().eval(null);
            if (!rs.hasOne()) {
                throw new XPathException(this.getASTNode(), "Type error: sequence with less or more than one item is not allowed here");
            }
            AtomicValue rv = rs.itemAt(0).atomize();
            NodeSetIterator i = nodes.iterator();
            while (i.hasNext()) {
                NodeProxy current = (NodeProxy)i.next();
                AtomicValue lv = current.atomize();
                if (!ValueComparison.compareAtomic(collator, lv, rv, -1, 4)) continue;
                result.add(current);
            }
        }
        return result;
    }

    public static boolean compareAtomic(Collator collator, AtomicValue lv, AtomicValue rv, int truncation, int relation) throws XPathException {
        int ctype;
        int ltype = lv.getType();
        int rtype = rv.getType();
        if (ltype == 21) {
            lv = lv.convertTo(22);
        }
        if (rtype == 21) {
            rv = rv.convertTo(22);
        }
        if ((ctype = Type.getCommonSuperType(ltype = lv.getType(), rtype = rv.getType())) == 30) {
            if (ltype == 32) {
                if (rtype == 33) {
                    lv = lv.convertTo(33);
                } else if (rtype == 34) {
                    lv = lv.convertTo(34);
                }
            } else if (rtype == 32) {
                if (ltype == 33) {
                    rv = rv.convertTo(33);
                } else if (ltype == 34) {
                    rv = rv.convertTo(34);
                }
            } else {
                if (ltype == 33 && rtype == 34) {
                    lv = lv.convertTo(34);
                }
                if (rtype == 33 && ltype == 34) {
                    rv = rv.convertTo(34);
                }
            }
        } else {
            lv = lv.convertTo(ctype);
            rv = rv.convertTo(ctype);
        }
        if (truncation != -1) {
            lv = lv.convertTo(22);
        }
        switch (truncation) {
            case 0: {
                return lv.startsWith(collator, rv);
            }
            case 1: {
                return lv.endsWith(collator, rv);
            }
            case 2: {
                return lv.contains(collator, rv);
            }
        }
        return lv.compareTo(collator, relation, rv);
    }

    public void dump(ExpressionDumper dumper) {
        this.getLeft().dump(dumper);
        dumper.display(" ").display(Constants.VOPS[this.relation]).display(" ");
        this.getRight().dump(dumper);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.getLeft().toString());
        result.append(" ").append(Constants.VOPS[this.relation]).append(" ");
        result.append(this.getRight().toString());
        return result.toString();
    }
}

