/*
 * Decompiled with CFR 0.152.
 */
package org.exist.webstart;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.exist.webstart.JnlpHelper;
import org.exist.webstart.JnlpJarFiles;
import org.exist.webstart.JnlpWriter;

public class JnlpServlet
extends HttpServlet {
    private static Logger logger = Logger.getLogger((Class)JnlpServlet.class);
    private JnlpJarFiles jf = null;
    private JnlpHelper jh = null;

    public void init() {
        logger.info((Object)"Initializing JNLP servlet");
        this.jh = new JnlpHelper();
        this.jf = new JnlpJarFiles(this.jh);
    }

    private String stripFilename(String URI2) {
        int lastPos = URI2.lastIndexOf("/");
        return URI2.substring(lastPos + 1);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        JnlpWriter jw = new JnlpWriter();
        String URI2 = request.getRequestURI();
        logger.debug((Object)("Requested URI=" + URI2));
        if (URI2.endsWith(".jnlp")) {
            jw.writeJnlpXML(this.jf, request, response);
        } else if (URI2.endsWith(".jar")) {
            String filename = this.stripFilename(request.getPathInfo());
            jw.sendJar(this.jf, filename, request, response);
        } else if (URI2.endsWith(".gif") || URI2.endsWith(".jpg")) {
            String filename = this.stripFilename(request.getPathInfo());
            jw.sendImage(this.jh, this.jf, filename, response);
        } else {
            logger.error((Object)"Invalid filename extension.");
            response.sendError(403, "Invalid filename extension.");
            return;
        }
    }
}

