/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.index;

import java.nio.ByteBuffer;
import org.exist.storage.DBBroker;
import org.exist.storage.NativeBroker;
import org.exist.storage.index.BFile;
import org.exist.storage.journal.AbstractLoggable;
import org.exist.storage.txn.Txn;

public abstract class AbstractBFileLoggable
extends AbstractLoggable {
    protected NativeBroker broker;
    protected byte fileId;

    public AbstractBFileLoggable(byte type, byte fileId, Txn transaction) {
        super(type, transaction.getId());
        this.fileId = fileId;
    }

    public AbstractBFileLoggable(DBBroker broker, long transactionId) {
        super((byte)48, transactionId);
        this.broker = (NativeBroker)broker;
    }

    public void write(ByteBuffer out) {
        out.put(this.fileId);
    }

    public void read(ByteBuffer in) {
        this.fileId = in.get();
    }

    public int getLogSize() {
        return 1;
    }

    protected BFile getIndexFile() {
        return (BFile)this.broker.getStorage(this.fileId);
    }

    public String dump() {
        return super.dump() + " [BFile]";
    }
}

