/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom;

import java.util.Iterator;
import java.util.Properties;
import org.exist.dom.AttrImpl;
import org.exist.dom.ContextItem;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.dom.ElementImpl;
import org.exist.dom.ExtArrayNodeSet;
import org.exist.dom.Match;
import org.exist.dom.NodeImpl;
import org.exist.dom.NodeSet;
import org.exist.dom.NodeSetHelper;
import org.exist.dom.NodeSetIterator;
import org.exist.dom.QName;
import org.exist.dom.StoredNode;
import org.exist.memtree.DocumentBuilderReceiver;
import org.exist.numbering.NodeId;
import org.exist.storage.DBBroker;
import org.exist.storage.RangeIndexSpec;
import org.exist.storage.StorageAddress;
import org.exist.storage.serializers.Serializer;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.UntypedAtomicValue;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class NodeProxy
implements NodeSet,
NodeValue,
Comparable {
    public static final int DOCUMENT_NODE_GID = -1;
    public static final int UNKNOWN_NODE_GID = 0;
    public static final int DOCUMENT_ELEMENT_GID = 1;
    public static final short UNKNOWN_NODE_TYPE = -1;
    public static final int UNKNOWN_NODE_LEVEL = -1;
    private DocumentImpl doc = null;
    private NodeId nodeId;
    private long internalAddress = -1L;
    private short nodeType = (short)-1;
    private Match match = null;
    private ContextItem context = null;

    public NodeProxy(DocumentImpl doc, NodeId nodeId) {
        this(doc, nodeId, -1, -1L);
    }

    public NodeProxy(DocumentImpl doc, NodeId nodeId, long address) {
        this(doc, nodeId, -1, address);
    }

    public NodeProxy(DocumentImpl doc, NodeId nodeId, short nodeType) {
        this(doc, nodeId, nodeType, -1L);
    }

    public NodeProxy(DocumentImpl doc, NodeId nodeId, short nodeType, long address) {
        this.doc = doc;
        this.nodeType = nodeType;
        this.internalAddress = address;
        this.nodeId = nodeId;
    }

    public NodeProxy(NodeProxy p) {
        this(p.doc, p.nodeId, p.nodeType, p.internalAddress);
        this.match = p.match;
    }

    public NodeProxy(StoredNode n) {
        this((DocumentImpl)n.getOwnerDocument(), n.getNodeId(), n.getNodeType(), n.getInternalAddress());
    }

    public NodeProxy(DocumentImpl doc) {
        this(doc, NodeId.DOCUMENT_NODE, 9, -1L);
    }

    public void setNodeId(NodeId id) {
        this.nodeId = id;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public int getImplementationType() {
        return 1;
    }

    public int compareTo(NodeProxy other) {
        int diff = this.doc.getDocId() - other.doc.getDocId();
        if (diff != 0) {
            return diff;
        }
        return this.nodeId.compareTo(other.nodeId);
    }

    public int compareTo(Object other) {
        if (!(other instanceof NodeProxy)) {
            return 1;
        }
        return this.compareTo((NodeProxy)other);
    }

    public boolean equals(Object other) {
        if (!(other instanceof NodeProxy)) {
            return false;
        }
        NodeProxy otherNode = (NodeProxy)other;
        if (otherNode.doc.getDocId() != this.doc.getDocId()) {
            return false;
        }
        return otherNode.nodeId.equals(this.nodeId);
    }

    public boolean equals(NodeValue other) throws XPathException {
        if (other.getImplementationType() != 1) {
            throw new XPathException("cannot compare persistent node with in-memory node");
        }
        NodeProxy otherNode = (NodeProxy)other;
        if (otherNode.doc.getDocId() != this.doc.getDocId()) {
            return false;
        }
        return otherNode.nodeId.equals(this.nodeId);
    }

    public boolean before(NodeValue other, boolean isPreceding) throws XPathException {
        if (other.getImplementationType() != 1) {
            throw new XPathException("cannot compare persistent node with in-memory node");
        }
        NodeProxy otherNode = (NodeProxy)other;
        if (this.doc.getDocId() != otherNode.doc.getDocId()) {
            return this.doc.getDocId() < otherNode.doc.getDocId();
        }
        return this.nodeId.before(otherNode.nodeId, isPreceding);
    }

    public boolean after(NodeValue other, boolean isFollowing) throws XPathException {
        if (other.getImplementationType() != 1) {
            throw new XPathException("cannot compare persistent node with in-memory node");
        }
        NodeProxy otherNode = (NodeProxy)other;
        if (this.doc.getDocId() != otherNode.doc.getDocId()) {
            return this.doc.getDocId() > otherNode.doc.getDocId();
        }
        return this.nodeId.after(otherNode.nodeId, isFollowing);
    }

    public Document getOwnerDocument() {
        return this.doc;
    }

    public final DocumentImpl getDocument() {
        return this.doc;
    }

    public boolean isDocument() {
        return this.nodeType == 9;
    }

    public Node getNode() {
        if (this.isDocument()) {
            return this.doc;
        }
        NodeImpl realNode = (NodeImpl)this.doc.getNode(this);
        this.nodeType = realNode.getNodeType();
        return realNode;
    }

    public short getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(short nodeType) {
        this.nodeType = nodeType;
    }

    public long getInternalAddress() {
        return this.internalAddress;
    }

    public void setInternalAddress(long internalAddress) {
        this.internalAddress = internalAddress;
    }

    public void setIndexType(int type) {
        this.internalAddress = StorageAddress.setIndexType(this.internalAddress, (short)type);
    }

    public int getIndexType() {
        return RangeIndexSpec.indexTypeToXPath(StorageAddress.indexTypeFromPointer(this.internalAddress));
    }

    public boolean hasTextIndex() {
        return RangeIndexSpec.hasFulltextIndex(StorageAddress.indexTypeFromPointer(this.internalAddress));
    }

    public boolean hasMixedContent() {
        return RangeIndexSpec.hasMixedContent(StorageAddress.indexTypeFromPointer(this.internalAddress));
    }

    public Match getMatches() {
        return this.match;
    }

    public void setMatches(Match match) {
        this.match = match;
    }

    public boolean hasMatch(Match m) {
        if (m == null || this.match == null) {
            return false;
        }
        Match next = this.match;
        do {
            if (!next.equals(m)) continue;
            return true;
        } while ((next = next.getNextMatch()) != null);
        return false;
    }

    public void addMatch(Match m) {
        if (this.match == null) {
            this.match = m;
            this.match.nextMatch = null;
            return;
        }
        Match next = this.match;
        while (next != null) {
            if (next.matchEquals(m)) {
                next.mergeOffsets(m);
                return;
            }
            if (next.nextMatch == null) {
                next.nextMatch = m;
                break;
            }
            next = next.nextMatch;
        }
    }

    public void addMatches(NodeProxy p) {
        if (p == this) {
            return;
        }
        Match m = p.getMatches();
        while (m != null) {
            this.addMatch(m.newCopy());
            m = m.nextMatch;
        }
    }

    public void addContextNode(int contextId, NodeValue node) {
        if (node.getImplementationType() != 1) {
            return;
        }
        NodeProxy contextNode = (NodeProxy)node;
        if (this.context == null) {
            this.context = new ContextItem(contextId, contextNode);
            return;
        }
        for (ContextItem next = this.context; !(next == null || contextId == next.getContextId() && next.getNode().getNodeId().equals(contextNode.getNodeId())); next = next.getNextDirect()) {
            if (next.getNextDirect() != null) continue;
            next.setNextContextItem(new ContextItem(contextId, contextNode));
            break;
        }
    }

    public void addContext(NodeProxy other) {
        for (ContextItem next = other.context; next != null; next = next.getNextDirect()) {
            this.addContextNode(next.getContextId(), next.getNode());
        }
    }

    public void copyContext(NodeProxy node) {
        this.context = node.getContext();
    }

    public void deepCopyContext(NodeProxy node) {
        this.context = null;
        ContextItem newContext = null;
        for (ContextItem next = node.context; next != null; next = next.getNextDirect()) {
            if (newContext == null) {
                this.context = newContext = new ContextItem(next.getContextId(), next.getNode());
                continue;
            }
            newContext.setNextContextItem(new ContextItem(next.getContextId(), next.getNode()));
            newContext = newContext.getNextDirect();
        }
    }

    public void deepCopyContext(NodeProxy node, int addContextId) {
        if (this.context == null) {
            this.deepCopyContext(node);
        }
        this.addContextNode(addContextId, node);
    }

    public void clearContext(int contextId) {
        this.context = null;
    }

    public ContextItem getContext() {
        return this.context;
    }

    public String debugContext() {
        StringBuffer buf = new StringBuffer();
        buf.append("Context for " + this.nodeId + " [ " + this.toString() + "] : ");
        for (ContextItem next = this.context; next != null; next = next.getNextDirect()) {
            buf.append('[');
            buf.append(next.getNode().getNodeId());
            buf.append(':');
            buf.append(next.getContextId());
            buf.append("] ");
        }
        return buf.toString();
    }

    public int getType() {
        switch (this.nodeType) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 7: {
                return 4;
            }
            case 8: {
                return 5;
            }
            case 9: {
                return 6;
            }
        }
        return -1;
    }

    public boolean isPersistentSet() {
        return true;
    }

    public void nodeMoved(NodeId oldNodeId, StoredNode newNode) {
        if (this.nodeId.equals(oldNodeId)) {
            this.nodeId = newNode.getNodeId();
            this.internalAddress = newNode.getInternalAddress();
        }
    }

    public Sequence toSequence() {
        return this;
    }

    public String getNodeValue() {
        if (this.isDocument()) {
            Element e = this.doc.getDocumentElement();
            if (e instanceof NodeProxy) {
                return this.doc.getBroker().getNodeValue(new StoredNode((NodeProxy)((Object)e)), false);
            }
            if (e != null) {
                return this.doc.getBroker().getNodeValue((ElementImpl)e, false);
            }
            return "";
        }
        return this.doc.getBroker().getNodeValue(new StoredNode(this), false);
    }

    public String getNodeValueSeparated() {
        return this.doc.getBroker().getNodeValue(new StoredNode(this), true);
    }

    public String getStringValue() {
        return this.getNodeValue();
    }

    public AtomicValue convertTo(int requiredType) throws XPathException {
        return new StringValue(this.getNodeValue()).convertTo(requiredType);
    }

    public AtomicValue atomize() throws XPathException {
        return new UntypedAtomicValue(this.getNodeValue());
    }

    public void toSAX(DBBroker broker, ContentHandler handler, Properties properties) throws SAXException {
        Serializer serializer = broker.getSerializer();
        serializer.reset();
        serializer.setProperty("sax-document-events", "false");
        if (properties != null) {
            serializer.setProperties(properties);
        }
        serializer.setSAXHandlers(handler, null);
        serializer.toSAX(this);
    }

    public void copyTo(DBBroker broker, DocumentBuilderReceiver receiver) throws SAXException {
        NodeImpl node = null;
        if (this.nodeType < 0) {
            node = (NodeImpl)this.getNode();
        }
        if (this.nodeType == 2) {
            AttrImpl attr = node == null ? (AttrImpl)this.getNode() : (AttrImpl)node;
            receiver.attribute(attr.getQName(), attr.getValue());
        } else {
            receiver.addReferenceNode(this);
        }
    }

    public int conversionPreference(Class javaClass) {
        if (javaClass.isAssignableFrom(NodeProxy.class)) {
            return 0;
        }
        if (javaClass.isAssignableFrom(Node.class)) {
            return 1;
        }
        if (javaClass == String.class || javaClass == CharSequence.class) {
            return 2;
        }
        if (javaClass == Character.class || javaClass == Character.TYPE) {
            return 2;
        }
        if (javaClass == Double.class || javaClass == Double.TYPE) {
            return 10;
        }
        if (javaClass == Float.class || javaClass == Float.TYPE) {
            return 11;
        }
        if (javaClass == Long.class || javaClass == Long.TYPE) {
            return 12;
        }
        if (javaClass == Integer.class || javaClass == Integer.TYPE) {
            return 13;
        }
        if (javaClass == Short.class || javaClass == Short.TYPE) {
            return 14;
        }
        if (javaClass == Byte.class || javaClass == Byte.TYPE) {
            return 15;
        }
        if (javaClass == Boolean.class || javaClass == Boolean.TYPE) {
            return 16;
        }
        if (javaClass == Object.class) {
            return 20;
        }
        return Integer.MAX_VALUE;
    }

    public Object toJavaObject(Class target) throws XPathException {
        if (target.isAssignableFrom(NodeProxy.class)) {
            return this;
        }
        if (target.isAssignableFrom(Node.class)) {
            return this.getNode();
        }
        if (target == Object.class) {
            return this.getNode();
        }
        StringValue v = new StringValue(this.getStringValue());
        return v.toJavaObject(target);
    }

    public int getItemType() {
        return this.getType();
    }

    public int getCardinality() {
        return 2;
    }

    public boolean isCached() {
        return false;
    }

    public void setIsCached(boolean cached) {
    }

    public NodeSet toNodeSet() throws XPathException {
        return this;
    }

    public boolean effectiveBooleanValue() throws XPathException {
        return true;
    }

    public void removeDuplicates() {
    }

    public void setSelfAsContext(int contextId) {
        this.addContextNode(contextId, this);
    }

    public NodeSetIterator iterator() {
        return new SingleNodeIterator(this);
    }

    public SequenceIterator iterate() throws XPathException {
        return new SingleNodeIterator(this);
    }

    public SequenceIterator unorderedIterator() {
        return new SingleNodeIterator(this);
    }

    public boolean contains(NodeProxy proxy) {
        if (this.doc.getDocId() != proxy.doc.getDocId()) {
            return false;
        }
        return this.nodeId.equals(proxy.getNodeId());
    }

    public void addAll(NodeSet other) {
        throw new RuntimeException("Method not supported");
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean hasOne() {
        return true;
    }

    public boolean hasMany() {
        return false;
    }

    public void add(NodeProxy proxy) {
        throw new RuntimeException("Method not supported");
    }

    public void add(Item item) throws XPathException {
        throw new RuntimeException("Method not supported");
    }

    public void add(NodeProxy proxy, int sizeHint) {
        throw new RuntimeException("Method not supported");
    }

    public void addAll(Sequence other) throws XPathException {
        throw new RuntimeException("Method not supported");
    }

    public int getLength() {
        return 1;
    }

    public int getItemCount() {
        return 1;
    }

    public Node item(int pos) {
        return pos > 0 ? null : this.getNode();
    }

    public Item itemAt(int pos) {
        return pos > 0 ? null : this;
    }

    public NodeProxy get(int pos) {
        return pos > 0 ? null : this;
    }

    public NodeProxy get(NodeProxy p) {
        return this.contains(p) ? this : null;
    }

    public NodeProxy get(DocumentImpl document, NodeId nodeId) {
        if (!this.nodeId.equals(nodeId)) {
            return null;
        }
        if (this.doc.getDocId() != document.getDocId()) {
            return null;
        }
        return this;
    }

    public NodeProxy parentWithChild(NodeProxy proxy, boolean directParent, boolean includeSelf, int level) {
        return this.parentWithChild(proxy.getDocument(), proxy.getNodeId(), directParent, includeSelf);
    }

    public NodeProxy parentWithChild(DocumentImpl otherDoc, NodeId otherId, boolean directParent, boolean includeSelf) {
        if (otherDoc.getDocId() != this.doc.getDocId()) {
            return null;
        }
        if (includeSelf && otherId.compareTo(this.nodeId) == 0) {
            return this;
        }
        for (otherId = otherId.getParentId(); otherId != null; otherId = otherId.getParentId()) {
            if (otherId.compareTo(this.nodeId) == 0) {
                return this;
            }
            if (!directParent) continue;
            return null;
        }
        return null;
    }

    public NodeSet getContextNodes(int contextId) {
        ExtArrayNodeSet result = new ExtArrayNodeSet();
        for (ContextItem contextNode = this.getContext(); contextNode != null; contextNode = contextNode.getNextDirect()) {
            NodeProxy p = contextNode.getNode();
            p.addMatches(this);
            if (result.contains(p)) continue;
            if (contextId != -1) {
                p.addContextNode(contextId, p);
            }
            result.add(p);
        }
        return result;
    }

    public int getState() {
        return 1;
    }

    public boolean hasChanged(int previousState) {
        return false;
    }

    public int getSizeHint(DocumentImpl document) {
        if (document.getDocId() == this.doc.getDocId()) {
            return 1;
        }
        return -1;
    }

    public DocumentSet getDocumentSet() {
        DocumentSet docs = new DocumentSet(1);
        docs.add(this.doc);
        return docs;
    }

    public Iterator getCollectionIterator() {
        return new Iterator(){
            boolean hasNext = true;

            public boolean hasNext() {
                return this.hasNext;
            }

            public Object next() {
                this.hasNext = false;
                return NodeProxy.this.getDocument().getCollection();
            }

            public void remove() {
            }
        };
    }

    public NodeSet intersection(NodeSet other) {
        if (other.contains(this)) {
            return this;
        }
        return NodeSet.EMPTY_SET;
    }

    public NodeSet deepIntersection(NodeSet other) {
        NodeProxy p = other.parentWithChild(this, false, true, -1);
        if (p == null) {
            return NodeSet.EMPTY_SET;
        }
        if (!this.nodeId.equals(p.nodeId)) {
            p.addMatches(this);
        }
        return p;
    }

    public NodeSet union(NodeSet other) {
        ExtArrayNodeSet result = new ExtArrayNodeSet();
        result.addAll(other);
        result.add(this);
        return result;
    }

    public NodeSet except(NodeSet other) {
        return other.contains(this) ? NodeSet.EMPTY_SET : this;
    }

    public NodeSet filterDocuments(NodeSet otherSet) {
        DocumentSet docs = otherSet.getDocumentSet();
        if (docs.contains(this.doc.getDocId())) {
            return this;
        }
        return NodeSet.EMPTY_SET;
    }

    public void setProcessInReverseOrder(boolean inReverseOrder) {
    }

    public boolean getProcessInReverseOrder() {
        return false;
    }

    public NodeSet getParents(int contextId) {
        NodeId pid = this.nodeId.getParentId();
        if (pid == null || pid == NodeId.DOCUMENT_NODE) {
            return NodeSet.EMPTY_SET;
        }
        NodeProxy parent = new NodeProxy(this.doc, pid, 1);
        if (contextId != -1) {
            parent.addContextNode(contextId, this);
        } else {
            parent.copyContext(this);
        }
        return parent;
    }

    public NodeSet getAncestors(int contextId, boolean includeSelf) {
        ExtArrayNodeSet ancestors = new ExtArrayNodeSet();
        if (includeSelf) {
            ancestors.add(this);
        }
        for (NodeId pid = this.nodeId.getParentId(); pid != null; pid = pid.getParentId()) {
            NodeProxy parent = new NodeProxy(this.getDocument(), pid, 1);
            if (contextId != -1) {
                parent.addContextNode(contextId, this);
            } else {
                parent.copyContext(this);
            }
            ancestors.add(parent);
        }
        return ancestors;
    }

    public NodeSet selectParentChild(NodeSet al, int mode) {
        return this.selectParentChild(al, mode, -1);
    }

    public NodeSet selectParentChild(NodeSet al, int mode, int contextId) {
        return NodeSetHelper.selectParentChild(this, al, mode, contextId);
    }

    public NodeSet selectAncestors(NodeSet al, boolean includeSelf, int contextId) {
        return NodeSetHelper.selectAncestors(this, al, includeSelf, contextId);
    }

    public NodeSet selectPrecedingSiblings(NodeSet siblings, int contextId) {
        return NodeSetHelper.selectPrecedingSiblings(this, siblings, contextId);
    }

    public NodeSet selectFollowingSiblings(NodeSet siblings, int contextId) {
        return NodeSetHelper.selectFollowingSiblings(this, siblings, contextId);
    }

    public NodeSet selectAncestorDescendant(NodeSet al, int mode, boolean includeSelf, int contextId) {
        return NodeSetHelper.selectAncestorDescendant(this, al, mode, includeSelf, contextId);
    }

    public NodeSet selectPreceding(NodeSet preceding) throws XPathException {
        return NodeSetHelper.selectPreceding(this, preceding);
    }

    public NodeSet selectFollowing(NodeSet following) throws XPathException {
        return NodeSetHelper.selectFollowing(this, following);
    }

    public NodeSet directSelectAttribute(QName qname, int contextId) {
        if (this.nodeType != -1 && this.nodeType != 1) {
            return NodeSet.EMPTY_SET;
        }
        NodeImpl node = (NodeImpl)this.getNode();
        if (node.getNodeType() != 1) {
            return NodeSet.EMPTY_SET;
        }
        AttrImpl attr = (AttrImpl)((ElementImpl)node).getAttributeNodeNS(qname.getNamespaceURI(), qname.getLocalName());
        if (attr == null) {
            return NodeSet.EMPTY_SET;
        }
        NodeProxy child = new NodeProxy(this.doc, attr.getNodeId(), 2, attr.getInternalAddress());
        if (-1 != contextId) {
            child.addContextNode(contextId, this);
        } else {
            child.copyContext(this);
        }
        return child;
    }

    public NodeSet directSelectChild(QName qname, int contextId) {
        if (this.nodeType != -1 && this.nodeType != 1) {
            return NodeSet.EMPTY_SET;
        }
        NodeImpl node = (NodeImpl)this.getNode();
        if (node.getNodeType() != 1) {
            return NodeSet.EMPTY_SET;
        }
        NodeList children = node.getChildNodes();
        if (children.getLength() == 0) {
            return NodeSet.EMPTY_SET;
        }
        ExtArrayNodeSet result = new ExtArrayNodeSet();
        for (int i = 0; i < children.getLength(); ++i) {
            StoredNode child = (StoredNode)children.item(i);
            if (!child.getQName().equals(qname)) continue;
            NodeProxy p = new NodeProxy(this.doc, child.getNodeId(), 1, child.getInternalAddress());
            if (-1 != contextId) {
                p.addContextNode(contextId, this);
            } else {
                p.copyContext(this);
            }
            p.addMatches(this);
            result.add(p);
        }
        return result;
    }

    public String toString() {
        if (this.nodeId == NodeId.DOCUMENT_NODE) {
            return "Document node for " + this.doc.getDocId();
        }
        return this.doc.getNode(this.nodeId).toString();
    }

    private static final class SingleNodeIterator
    implements NodeSetIterator,
    SequenceIterator {
        private boolean hasNext = true;
        private NodeProxy node;

        public SingleNodeIterator(NodeProxy node) {
            this.node = node;
        }

        public boolean hasNext() {
            return this.hasNext;
        }

        public Object next() {
            if (!this.hasNext) {
                return null;
            }
            this.hasNext = false;
            return this.node;
        }

        public NodeProxy peekNode() {
            return this.node;
        }

        public void remove() {
            throw new RuntimeException("Method not supported");
        }

        public Item nextItem() {
            if (!this.hasNext) {
                return null;
            }
            this.hasNext = false;
            return this.node;
        }

        public void setPosition(NodeProxy proxy) {
            this.node = proxy;
            this.hasNext = true;
        }
    }
}

