/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client.xacml;

import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import org.exist.client.xacml.PolicyElementEditor;
import org.exist.client.xacml.RuleNode;
import org.exist.client.xacml.XACMLTreeNode;

public class RuleEditor
extends PolicyElementEditor {
    public static final String PERMIT = "Permit";
    public static final String DENY = "Deny";

    protected String getComboLabel() {
        return "Rule Effect:";
    }

    protected ComboBoxModel getComboModel() {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement(PERMIT);
        model.addElement(DENY);
        return model;
    }

    protected Object getComboPrototype() {
        return PERMIT;
    }

    public int getEffect() {
        String effect = (String)this.getSelectedItem();
        if (DENY.equals(effect)) {
            return 1;
        }
        if (PERMIT.equals(effect)) {
            return 0;
        }
        throw new IllegalStateException("Invalid effect: '" + effect + "'");
    }

    public void setNode(XACMLTreeNode treeNode) {
        if (!(treeNode instanceof RuleNode)) {
            throw new IllegalArgumentException("RuleEditor can only edit RuleNodes");
        }
        RuleNode node = (RuleNode)treeNode;
        super.setNode(node);
        int effect = node.getEffect();
        if (effect == 1) {
            this.setSelectedItem(DENY);
        } else if (effect == 0) {
            this.setSelectedItem(PERMIT);
        } else {
            throw new IllegalArgumentException("Unknown effect for rule '" + this.getId() + "'");
        }
    }

    public void pushChanges() {
        super.pushChanges();
        int effect = this.getEffect();
        ((RuleNode)this.node).setEffect(effect);
    }
}

