/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.exist.client.InteractiveClient;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;

public class CollectionXConf {
    private InteractiveClient client = null;
    private String path = null;
    Collection collection = null;
    Resource resConfig = null;
    private LinkedHashMap customNamespaces = null;
    private FullTextIndex fulltextIndex = null;
    private RangeIndex[] rangeIndexes = null;
    private QNameIndex[] qnameIndexes;
    private Trigger[] triggers = null;
    private boolean hasChanged = false;

    CollectionXConf(String CollectionName2, InteractiveClient client) throws XMLDBException {
        this.client = client;
        this.path = "/db/system/config" + CollectionName2;
        this.collection = client.getCollection(this.path);
        if (this.collection == null) {
            return;
        }
        this.resConfig = this.collection.getResource("collection.xconf");
        if (this.resConfig == null) {
            return;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document docConfig = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            docConfig = builder.parse(new ByteArrayInputStream(this.resConfig.getContent().toString().getBytes()));
        }
        catch (ParserConfigurationException pce) {
        }
        catch (SAXException se) {
        }
        catch (IOException ioe) {
            // empty catch block
        }
        Element xconf = docConfig.getDocumentElement();
        this.customNamespaces = this.getCustomNamespaces(xconf);
        this.fulltextIndex = this.getFullTextIndex(xconf);
        this.rangeIndexes = this.getRangeIndexes(xconf);
        this.qnameIndexes = this.getQNameIndexes(xconf);
        this.triggers = this.getTriggers(xconf);
    }

    public boolean getFullTextIndexDefaultAll() {
        return this.fulltextIndex != null ? this.fulltextIndex.getDefaultAll() : false;
    }

    public void setFullTextIndexDefaultAll(boolean defaultAll) {
        this.hasChanged = true;
        if (this.fulltextIndex == null) {
            this.fulltextIndex = new FullTextIndex(true, false, false, null);
        } else {
            this.fulltextIndex.setDefaultAll(defaultAll);
        }
    }

    public boolean getFullTextIndexAttributes() {
        return this.fulltextIndex != null ? this.fulltextIndex.getAttributes() : false;
    }

    public void setFullTextIndexAttributes(boolean attributes) {
        this.hasChanged = true;
        if (this.fulltextIndex == null) {
            this.fulltextIndex = new FullTextIndex(false, true, false, null);
        } else {
            this.fulltextIndex.setAttributes(attributes);
        }
    }

    public boolean getFullTextIndexAlphanum() {
        return this.fulltextIndex != null ? this.fulltextIndex.getAlphanum() : false;
    }

    public void setFullTextIndexAlphanum(boolean alphanum) {
        this.hasChanged = true;
        if (this.fulltextIndex == null) {
            this.fulltextIndex = new FullTextIndex(false, false, true, null);
        } else {
            this.fulltextIndex.setAlphanum(alphanum);
        }
    }

    public String getFullTextIndexPath(int index) {
        return this.fulltextIndex.getXPath(index);
    }

    public String getFullTextIndexPathAction(int index) {
        return this.fulltextIndex.getAction(index);
    }

    public int getFullTextPathCount() {
        if (this.fulltextIndex != null) {
            return this.fulltextIndex.getLength();
        }
        return 0;
    }

    public void addFullTextIndex(String XPath, String action) {
        this.hasChanged = true;
        if (this.fulltextIndex == null) {
            this.fulltextIndex = new FullTextIndex(false, false, false, null);
        }
        this.fulltextIndex.addIndex(XPath, action);
    }

    public void updateFullTextIndex(int index, String XPath, String action) {
        this.hasChanged = true;
        if (XPath != null) {
            this.fulltextIndex.setXPath(index, XPath);
        }
        if (action != null) {
            this.fulltextIndex.setAction(index, action);
        }
    }

    public void deleteFullTextIndex(int index) {
        this.hasChanged = true;
        this.fulltextIndex.deleteIndex(index);
    }

    public RangeIndex[] getRangeIndexes() {
        return this.rangeIndexes;
    }

    public RangeIndex getRangeIndex(int index) {
        return this.rangeIndexes[index];
    }

    public int getRangeIndexCount() {
        if (this.rangeIndexes != null) {
            return this.rangeIndexes.length;
        }
        return 0;
    }

    public void deleteRangeIndex(int index) {
        if (index < this.rangeIndexes.length) {
            this.hasChanged = true;
            if (this.rangeIndexes.length == 1) {
                this.rangeIndexes = null;
            } else {
                RangeIndex[] newRangeIndexes = new RangeIndex[this.rangeIndexes.length - 1];
                int x = 0;
                for (int i = 0; i < this.rangeIndexes.length; ++i) {
                    if (i == index) continue;
                    newRangeIndexes[x] = this.rangeIndexes[i];
                    ++x;
                }
                this.rangeIndexes = newRangeIndexes;
            }
        }
    }

    public void updateRangeIndex(int index, String XPath, String xsType) {
        this.hasChanged = true;
        if (XPath != null) {
            this.rangeIndexes[index].setXPath(XPath);
        }
        if (xsType != null) {
            this.rangeIndexes[index].setxsType(xsType);
        }
    }

    public void addRangeIndex(String XPath, String xsType) {
        this.hasChanged = true;
        if (this.rangeIndexes == null) {
            this.rangeIndexes = new RangeIndex[1];
            this.rangeIndexes[0] = new RangeIndex(XPath, xsType);
        } else {
            RangeIndex[] newRangeIndexes = new RangeIndex[this.rangeIndexes.length + 1];
            System.arraycopy(this.rangeIndexes, 0, newRangeIndexes, 0, this.rangeIndexes.length);
            newRangeIndexes[this.rangeIndexes.length] = new RangeIndex(XPath, xsType);
            this.rangeIndexes = newRangeIndexes;
        }
    }

    public QNameIndex[] getQNameIndexes() {
        return this.qnameIndexes;
    }

    public QNameIndex getQNameIndex(int index) {
        return this.qnameIndexes[index];
    }

    public int getQNameIndexCount() {
        if (this.qnameIndexes != null) {
            return this.qnameIndexes.length;
        }
        return 0;
    }

    public void deleteQNameIndex(int index) {
        if (index < this.qnameIndexes.length) {
            this.hasChanged = true;
            if (this.qnameIndexes.length == 1) {
                this.qnameIndexes = null;
            } else {
                QNameIndex[] newQNameIndexes = new QNameIndex[this.qnameIndexes.length - 1];
                int x = 0;
                for (int i = 0; i < this.qnameIndexes.length; ++i) {
                    if (i == index) continue;
                    newQNameIndexes[x] = this.qnameIndexes[i];
                    ++x;
                }
                this.qnameIndexes = newQNameIndexes;
            }
        }
    }

    public void updateQNameIndex(int index, String QName2, String xsType) {
        this.hasChanged = true;
        if (QName2 != null) {
            this.qnameIndexes[index].setQName(QName2);
        }
        if (xsType != null) {
            this.qnameIndexes[index].setxsType(xsType);
        }
    }

    public void addQNameIndex(String QName2, String xsType) {
        this.hasChanged = true;
        if (this.qnameIndexes == null) {
            this.qnameIndexes = new QNameIndex[1];
            this.qnameIndexes[0] = new QNameIndex(QName2, xsType);
        } else {
            QNameIndex[] newQNameIndexes = new QNameIndex[this.qnameIndexes.length + 1];
            System.arraycopy(this.qnameIndexes, 0, newQNameIndexes, 0, this.qnameIndexes.length);
            newQNameIndexes[this.qnameIndexes.length] = new QNameIndex(QName2, xsType);
            this.qnameIndexes = newQNameIndexes;
        }
    }

    public Trigger[] getTriggers() {
        return this.triggers;
    }

    public Trigger getTrigger(int index) {
        return this.triggers[index];
    }

    public int getTriggerCount() {
        if (this.triggers != null) {
            return this.triggers.length;
        }
        return 0;
    }

    public void deleteTrigger(int index) {
        if (index < this.triggers.length) {
            this.hasChanged = true;
            if (this.triggers.length == 1) {
                this.triggers = null;
            } else {
                Trigger[] newTriggers = new Trigger[this.triggers.length - 1];
                int x = 0;
                for (int i = 0; i < this.triggers.length; ++i) {
                    if (i == index) continue;
                    newTriggers[x] = this.triggers[i];
                    ++x;
                }
                this.triggers = newTriggers;
            }
        }
    }

    public void updateTrigger(int index, String triggerClass, boolean STORE_DOCUMENT_EVENT, boolean UPDATE_DOCUMENT_EVENT, boolean REMOVE_DOCUMENT_EVENT, boolean CREATE_COLLECTION_EVENT, boolean RENAME_COLLECTION_EVENT, boolean DELETE_COLLECTION_EVENT, Properties parameters) {
        this.hasChanged = true;
        if (triggerClass != null) {
            this.triggers[index].setTriggerClass(triggerClass);
        }
        this.triggers[index].setStoreDocumentEvent(STORE_DOCUMENT_EVENT);
        this.triggers[index].setUpdateDocumentEvent(UPDATE_DOCUMENT_EVENT);
        this.triggers[index].setRemoveDocumentEvent(REMOVE_DOCUMENT_EVENT);
        this.triggers[index].setCreateCollectionEvent(CREATE_COLLECTION_EVENT);
        this.triggers[index].setRenameCollectionEvent(RENAME_COLLECTION_EVENT);
        this.triggers[index].setDeleteCollectionEvent(DELETE_COLLECTION_EVENT);
    }

    public void addTrigger(String triggerClass, boolean STORE_DOCUMENT_EVENT, boolean UPDATE_DOCUMENT_EVENT, boolean REMOVE_DOCUMENT_EVENT, boolean CREATE_COLLECTION_EVENT, boolean RENAME_COLLECTION_EVENT, boolean DELETE_COLLECTION_EVENT, Properties parameters) {
        this.hasChanged = true;
        if (this.triggers == null) {
            this.triggers = new Trigger[1];
            this.triggers[0] = new Trigger(triggerClass, STORE_DOCUMENT_EVENT, UPDATE_DOCUMENT_EVENT, REMOVE_DOCUMENT_EVENT, CREATE_COLLECTION_EVENT, RENAME_COLLECTION_EVENT, DELETE_COLLECTION_EVENT, parameters);
        } else {
            Trigger[] newTriggers = new Trigger[this.triggers.length + 1];
            System.arraycopy(this.triggers, 0, newTriggers, 0, this.triggers.length);
            newTriggers[this.triggers.length] = new Trigger(triggerClass, STORE_DOCUMENT_EVENT, UPDATE_DOCUMENT_EVENT, REMOVE_DOCUMENT_EVENT, CREATE_COLLECTION_EVENT, RENAME_COLLECTION_EVENT, DELETE_COLLECTION_EVENT, parameters);
            this.triggers = newTriggers;
        }
    }

    private LinkedHashMap getCustomNamespaces(Element xconf) {
        NamedNodeMap attrs = xconf.getAttributes();
        if (attrs.getLength() > 1) {
            LinkedHashMap<String, String> namespaces = new LinkedHashMap<String, String>();
            for (int i = 0; i < attrs.getLength(); ++i) {
                Node a = attrs.item(i);
                if (!a.getNodeName().startsWith("xmlns:")) continue;
                String namespaceLocalName = a.getNodeName().substring(a.getNodeName().indexOf(":") + 1);
                namespaces.put(namespaceLocalName, a.getNodeValue());
            }
            return namespaces;
        }
        return null;
    }

    private FullTextIndex getFullTextIndex(Element xconf) {
        NodeList nlFullTextIndex = xconf.getElementsByTagName("fulltext");
        if (nlFullTextIndex.getLength() > 0) {
            boolean defaultAll = true;
            boolean attributes = false;
            boolean alphanum = false;
            FullTextIndexPath[] paths = null;
            Element elemFullTextIndex = (Element)nlFullTextIndex.item(0);
            defaultAll = elemFullTextIndex.getAttribute("default").equals("all");
            attributes = elemFullTextIndex.getAttribute("attributes").equals("true");
            alphanum = elemFullTextIndex.getAttribute("alphanum").equals("true");
            NodeList nlInclude = elemFullTextIndex.getElementsByTagName("include");
            NodeList nlExclude = elemFullTextIndex.getElementsByTagName("exclude");
            int iPaths = nlInclude.getLength() + nlExclude.getLength();
            if (iPaths > 0) {
                int i;
                paths = new FullTextIndexPath[iPaths];
                if (nlInclude.getLength() > 0) {
                    for (i = 0; i < nlInclude.getLength(); ++i) {
                        paths[i] = new FullTextIndexPath(((Element)nlInclude.item(i)).getAttribute("path"), "include");
                    }
                }
                if (nlExclude.getLength() > 0) {
                    for (i = 0; i < nlExclude.getLength(); ++i) {
                        paths[i] = new FullTextIndexPath(((Element)nlExclude.item(i)).getAttribute("path"), "exclude");
                    }
                }
            }
            return new FullTextIndex(defaultAll, attributes, alphanum, paths);
        }
        return null;
    }

    private RangeIndex[] getRangeIndexes(Element xconf) {
        ArrayList<RangeIndex> alRangeIndexes = new ArrayList<RangeIndex>();
        NodeList nlRangeIndexes = xconf.getElementsByTagName("create");
        if (nlRangeIndexes.getLength() > 0) {
            for (int i = 0; i < nlRangeIndexes.getLength(); ++i) {
                Element rangeIndex = (Element)nlRangeIndexes.item(i);
                if (rangeIndex.getAttribute("path").length() <= 0) continue;
                alRangeIndexes.add(new RangeIndex(rangeIndex.getAttribute("path"), rangeIndex.getAttribute("type")));
            }
            RangeIndex[] rangeIndexes = new RangeIndex[alRangeIndexes.size()];
            for (int i = 0; i < alRangeIndexes.size(); ++i) {
                rangeIndexes[i] = (RangeIndex)alRangeIndexes.get(i);
            }
            return rangeIndexes;
        }
        return null;
    }

    private QNameIndex[] getQNameIndexes(Element xconf) {
        ArrayList<QNameIndex> alQNameIndexes = new ArrayList<QNameIndex>();
        NodeList nlQNameIndexes = xconf.getElementsByTagName("create");
        if (nlQNameIndexes.getLength() > 0) {
            for (int i = 0; i < nlQNameIndexes.getLength(); ++i) {
                Element qnameIndex = (Element)nlQNameIndexes.item(i);
                if (qnameIndex.getAttribute("qname").length() <= 0) continue;
                alQNameIndexes.add(new QNameIndex(qnameIndex.getAttribute("qname"), qnameIndex.getAttribute("type")));
            }
            QNameIndex[] qnameIndexes = new QNameIndex[alQNameIndexes.size()];
            for (int i = 0; i < alQNameIndexes.size(); ++i) {
                qnameIndexes[i] = (QNameIndex)alQNameIndexes.get(i);
            }
            return qnameIndexes;
        }
        return null;
    }

    private Trigger[] getTriggers(Element xconf) {
        NodeList nlTriggers = xconf.getElementsByTagName("trigger");
        if (nlTriggers.getLength() > 0) {
            Trigger[] triggers = new Trigger[nlTriggers.getLength()];
            for (int i = 0; i < nlTriggers.getLength(); ++i) {
                Element trigger = (Element)nlTriggers.item(i);
                Properties parameters = new Properties();
                NodeList nlTriggerParameters = trigger.getElementsByTagName("parameter");
                if (nlTriggerParameters.getLength() > 0) {
                    for (int x = 0; x < nlTriggerParameters.getLength(); ++x) {
                        Element parameter = (Element)nlTriggerParameters.item(x);
                        parameters.setProperty(parameter.getAttribute("name"), parameter.getAttribute("value"));
                    }
                }
                triggers[i] = new Trigger(trigger.getAttribute("event"), trigger.getAttribute("class"), parameters);
            }
            return triggers;
        }
        return null;
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    private String toXMLString() {
        StringBuffer xconf = new StringBuffer();
        xconf.append("<collection xmlns=\"http://exist-db.org/collection-config/1.0\"");
        if (this.customNamespaces != null) {
            Set namespaceKeys = this.customNamespaces.keySet();
            Iterator itKeys = namespaceKeys.iterator();
            while (itKeys.hasNext()) {
                xconf.append(" ");
                String namespaceLocalName = (String)itKeys.next();
                String namespaceURL = (String)this.customNamespaces.get(namespaceLocalName);
                xconf.append("xmlns:" + namespaceLocalName + "=\"" + namespaceURL + "\"");
            }
        }
        xconf.append(">");
        xconf.append(System.getProperty("line.separator"));
        if (this.fulltextIndex != null || this.rangeIndexes != null || this.qnameIndexes != null) {
            xconf.append('\t');
            xconf.append("<index>");
            xconf.append(System.getProperty("line.separator"));
            if (this.fulltextIndex != null) {
                xconf.append("\t\t");
                xconf.append(this.fulltextIndex.toXMLString());
                xconf.append(System.getProperty("line.separator"));
            }
            if (this.rangeIndexes != null) {
                for (int r = 0; r < this.rangeIndexes.length; ++r) {
                    xconf.append("\t\t\t");
                    xconf.append(this.rangeIndexes[r].toXMLString());
                    xconf.append(System.getProperty("line.separator"));
                }
            }
            if (this.qnameIndexes != null) {
                for (int q = 0; q < this.qnameIndexes.length; ++q) {
                    xconf.append("\t\t\t");
                    xconf.append(this.qnameIndexes[q].toXMLString());
                    xconf.append(System.getProperty("line.separator"));
                }
            }
            xconf.append('\t');
            xconf.append("</index>");
            xconf.append(System.getProperty("line.separator"));
        }
        if (this.triggers != null) {
            xconf.append('\t');
            xconf.append("<triggers>");
            for (int t = 0; t < this.triggers.length; ++t) {
                xconf.append("\t\t\t");
                xconf.append(this.triggers[t].toXMLString());
                xconf.append(System.getProperty("line.separator"));
            }
            xconf.append('\t');
            xconf.append("</triggers>");
            xconf.append(System.getProperty("line.separator"));
        }
        xconf.append("</collection>");
        return xconf.toString();
    }

    public boolean Save() {
        try {
            if (this.resConfig == null) {
                if (this.collection == null) {
                    this.client.process("mkcol " + this.path);
                    this.collection = this.client.getCollection(this.path);
                }
                this.resConfig = this.collection.createResource("collection.xconf", "XMLResource");
            }
            this.resConfig.setContent((Object)this.toXMLString());
            this.collection.storeResource(this.resConfig);
        }
        catch (XMLDBException xmldbe) {
            return false;
        }
        return true;
    }

    protected class Trigger {
        private String triggerClass = null;
        private boolean STORE_DOCUMENT_EVENT = false;
        private boolean UPDATE_DOCUMENT_EVENT = false;
        private boolean REMOVE_DOCUMENT_EVENT = false;
        private boolean CREATE_COLLECTION_EVENT = false;
        private boolean RENAME_COLLECTION_EVENT = false;
        private boolean DELETE_COLLECTION_EVENT = false;
        private Properties parameters = null;

        Trigger(String triggerClass, boolean STORE_DOCUMENT_EVENT, boolean UPDATE_DOCUMENT_EVENT, boolean REMOVE_DOCUMENT_EVENT, boolean CREATE_COLLECTION_EVENT, boolean RENAME_COLLECTION_EVENT, boolean DELETE_COLLECTION_EVENT, Properties parameters) {
            this.triggerClass = triggerClass;
            this.STORE_DOCUMENT_EVENT = STORE_DOCUMENT_EVENT;
            this.UPDATE_DOCUMENT_EVENT = UPDATE_DOCUMENT_EVENT;
            this.REMOVE_DOCUMENT_EVENT = REMOVE_DOCUMENT_EVENT;
            this.CREATE_COLLECTION_EVENT = CREATE_COLLECTION_EVENT;
            this.RENAME_COLLECTION_EVENT = RENAME_COLLECTION_EVENT;
            this.DELETE_COLLECTION_EVENT = DELETE_COLLECTION_EVENT;
            this.parameters = parameters;
        }

        Trigger(String triggerClass, String triggerEvents, Properties parameters) {
            this.triggerClass = triggerClass;
            if (triggerEvents.indexOf("store") > -1) {
                this.STORE_DOCUMENT_EVENT = true;
            }
            if (triggerEvents.indexOf("update") > -1) {
                this.UPDATE_DOCUMENT_EVENT = true;
            }
            if (triggerEvents.indexOf("remove") > -1) {
                this.REMOVE_DOCUMENT_EVENT = true;
            }
            if (triggerEvents.indexOf("create") > -1) {
                this.CREATE_COLLECTION_EVENT = true;
            }
            if (triggerEvents.indexOf("rename") > -1) {
                this.RENAME_COLLECTION_EVENT = true;
            }
            if (triggerEvents.indexOf("delete") > -1) {
                this.DELETE_COLLECTION_EVENT = true;
            }
            this.parameters = parameters;
        }

        public String getTriggerClass() {
            return this.triggerClass;
        }

        public void setTriggerClass(String triggerClass) {
            this.triggerClass = triggerClass;
        }

        public boolean getStoreDocumentEvent() {
            return this.STORE_DOCUMENT_EVENT;
        }

        public void setStoreDocumentEvent(boolean store) {
            this.STORE_DOCUMENT_EVENT = store;
        }

        public boolean getUpdateDocumentEvent() {
            return this.UPDATE_DOCUMENT_EVENT;
        }

        public void setUpdateDocumentEvent(boolean update) {
            this.UPDATE_DOCUMENT_EVENT = update;
        }

        public boolean getRemoveDocumentEvent() {
            return this.REMOVE_DOCUMENT_EVENT;
        }

        public void setRemoveDocumentEvent(boolean remove) {
            this.REMOVE_DOCUMENT_EVENT = remove;
        }

        public boolean getCreateCollectionEvent() {
            return this.CREATE_COLLECTION_EVENT;
        }

        public void setCreateCollectionEvent(boolean create) {
            this.CREATE_COLLECTION_EVENT = create;
        }

        public boolean getRenameCollectionEvent() {
            return this.RENAME_COLLECTION_EVENT;
        }

        public void setRenameCollectionEvent(boolean rename) {
            this.RENAME_COLLECTION_EVENT = rename;
        }

        public boolean getDeleteCollectionEvent() {
            return this.DELETE_COLLECTION_EVENT;
        }

        public void setDeleteCollectionEvent(boolean delete) {
            this.DELETE_COLLECTION_EVENT = delete;
        }

        protected String toXMLString() {
            StringBuffer trigger = new StringBuffer();
            if (!this.triggerClass.equals("")) {
                trigger.append("<trigger class=\"");
                trigger.append(this.triggerClass);
                trigger.append("\" event=\"");
                if (this.STORE_DOCUMENT_EVENT) {
                    trigger.append("store,");
                }
                if (this.UPDATE_DOCUMENT_EVENT) {
                    trigger.append("update,");
                }
                if (this.REMOVE_DOCUMENT_EVENT) {
                    trigger.append("remove,");
                }
                if (this.CREATE_COLLECTION_EVENT) {
                    trigger.append("create,");
                }
                if (this.RENAME_COLLECTION_EVENT) {
                    trigger.append("rename,");
                }
                if (this.DELETE_COLLECTION_EVENT) {
                    trigger.append("delete,");
                }
                if (trigger.charAt(trigger.length() - 1) == ',') {
                    trigger.deleteCharAt(trigger.length() - 1);
                }
                trigger.append("\">");
                if (this.parameters != null && this.parameters.size() > 0) {
                    Enumeration<Object> pKeys = this.parameters.keys();
                    while (pKeys.hasMoreElements()) {
                        String name = (String)pKeys.nextElement();
                        String value = this.parameters.getProperty(name);
                        trigger.append("<parameter name=\"");
                        trigger.append(name);
                        trigger.append("\" value=\"");
                        trigger.append(value);
                        trigger.append("\"/>");
                    }
                }
                trigger.append("</trigger>");
            }
            return trigger.toString();
        }
    }

    protected class QNameIndex {
        private String QName = null;
        private String xsType = null;

        QNameIndex(String QName2, String xsType) {
            this.QName = QName2;
            this.xsType = xsType;
        }

        public String getQName() {
            return this.QName;
        }

        public String getxsType() {
            return this.xsType;
        }

        public void setQName(String QName2) {
            this.QName = QName2;
        }

        public void setxsType(String xsType) {
            this.xsType = xsType;
        }

        protected String toXMLString() {
            StringBuffer qname = new StringBuffer();
            qname.append("<create qname=\"");
            qname.append(this.QName);
            qname.append("\" type=\"");
            qname.append(this.xsType);
            qname.append("\"/>");
            return qname.toString();
        }
    }

    protected class RangeIndex {
        private String XPath = null;
        private String xsType = null;

        RangeIndex(String XPath, String xsType) {
            this.XPath = XPath;
            this.xsType = xsType;
        }

        public String getXPath() {
            return this.XPath;
        }

        public String getxsType() {
            return this.xsType;
        }

        public void setXPath(String XPath) {
            this.XPath = XPath;
        }

        public void setxsType(String xsType) {
            this.xsType = xsType;
        }

        protected String toXMLString() {
            StringBuffer range = new StringBuffer();
            range.append("<create path=\"");
            range.append(this.XPath);
            range.append("\" type=\"");
            range.append(this.xsType);
            range.append("\"/>");
            return range.toString();
        }
    }

    protected class FullTextIndex {
        boolean defaultAll = true;
        boolean attributes = false;
        boolean alphanum = false;
        FullTextIndexPath[] xpaths = null;

        FullTextIndex(boolean defaultAll, boolean attributes, boolean alphanum, FullTextIndexPath[] xpaths) {
            this.defaultAll = defaultAll;
            this.attributes = attributes;
            this.alphanum = alphanum;
            this.xpaths = xpaths;
        }

        public boolean getDefaultAll() {
            return this.defaultAll;
        }

        public void setDefaultAll(boolean defaultAll) {
            this.defaultAll = defaultAll;
        }

        public boolean getAttributes() {
            return this.attributes;
        }

        public void setAttributes(boolean attributes) {
            this.attributes = attributes;
        }

        public boolean getAlphanum() {
            return this.alphanum;
        }

        public void setAlphanum(boolean alphanum) {
            this.alphanum = alphanum;
        }

        public String getXPath(int index) {
            return this.xpaths[index].getXPath();
        }

        public String getAction(int index) {
            return this.xpaths[index].getAction();
        }

        public int getLength() {
            return this.xpaths != null ? this.xpaths.length : 0;
        }

        public void setXPath(int index, String XPath) {
            this.xpaths[index].setXPath(XPath);
        }

        public void setAction(int index, String action) {
            this.xpaths[index].setAction(action);
        }

        public void addIndex(String XPath, String action) {
            if (this.xpaths == null) {
                this.xpaths = new FullTextIndexPath[1];
                this.xpaths[0] = new FullTextIndexPath(XPath, action);
            } else {
                FullTextIndexPath[] newxpaths = new FullTextIndexPath[this.xpaths.length + 1];
                System.arraycopy(this.xpaths, 0, newxpaths, 0, this.xpaths.length);
                newxpaths[this.xpaths.length] = new FullTextIndexPath(XPath, action);
                this.xpaths = newxpaths;
            }
        }

        public void deleteIndex(int index) {
            if (index < this.xpaths.length) {
                if (this.xpaths.length == 1) {
                    this.xpaths = null;
                } else {
                    FullTextIndexPath[] newxpaths = new FullTextIndexPath[this.xpaths.length - 1];
                    int x = 0;
                    for (int i = 0; i < this.xpaths.length; ++i) {
                        if (i == index) continue;
                        newxpaths[x] = this.xpaths[i];
                        ++x;
                    }
                    this.xpaths = newxpaths;
                }
            }
        }

        protected String toXMLString() {
            StringBuffer fulltext = new StringBuffer();
            fulltext.append("<fulltext default=\"");
            fulltext.append(this.defaultAll ? "all" : "none");
            fulltext.append("\" attributes=\"");
            fulltext.append(this.attributes);
            fulltext.append("\" alphanum=\"");
            fulltext.append(this.alphanum);
            fulltext.append("\">");
            fulltext.append(System.getProperty("line.separator"));
            if (this.xpaths != null) {
                for (int i = 0; i < this.xpaths.length; ++i) {
                    fulltext.append('\t');
                    fulltext.append("<");
                    fulltext.append(this.xpaths[i].getAction());
                    fulltext.append(" path=\"");
                    fulltext.append(this.xpaths[i].getXPath());
                    fulltext.append("\"/>");
                    fulltext.append(System.getProperty("line.separator"));
                }
            }
            fulltext.append("</fulltext>");
            return fulltext.toString();
        }
    }

    protected class FullTextIndexPath {
        public static final String ACTION_INCLUDE = "include";
        public static final String ACTION_EXCLUDE = "exclude";
        private String xpath = null;
        private String action = null;

        FullTextIndexPath(String xpath, String action) {
            this.xpath = xpath;
            this.action = action;
        }

        public String getXPath() {
            return this.xpath;
        }

        public String getAction() {
            return this.action;
        }

        public void setXPath(String xpath) {
            this.xpath = xpath;
        }

        public void setAction(String action) {
            this.action = action;
        }
    }
}

