/*
 * Decompiled with CFR 0.152.
 */
package org.exist.backup;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.exist.backup.BackupWriter;

public class ZipWriter
implements BackupWriter {
    private String currentPath;
    private ZipOutputStream out;
    private StringWriter contents;

    public ZipWriter(String zipFile, String collection) throws IOException {
        File file = new File(zipFile);
        this.out = new ZipOutputStream(new FileOutputStream(file));
        this.currentPath = collection;
    }

    public Writer newContents() throws IOException {
        this.contents = new StringWriter();
        return this.contents;
    }

    public void closeContents() throws IOException {
        ZipEntry entry = new ZipEntry(this.mkRelative(this.currentPath) + "/__contents__.xml");
        this.out.putNextEntry(entry);
        this.out.write(this.contents.toString().getBytes("UTF-8"));
        this.out.closeEntry();
    }

    public OutputStream newEntry(String name) throws IOException {
        ZipEntry entry = new ZipEntry(this.mkRelative(this.currentPath) + '/' + name);
        this.out.putNextEntry(entry);
        return this.out;
    }

    public void closeEntry() throws IOException {
        this.out.closeEntry();
    }

    public void newCollection(String name) {
        this.currentPath = this.currentPath + '/' + name;
    }

    public void closeCollection() {
        int p = this.currentPath.lastIndexOf(47);
        if (p > 0) {
            this.currentPath = this.currentPath.substring(0, p);
        }
    }

    public void close() throws IOException {
        this.out.close();
    }

    private String mkRelative(String path) {
        if (path.length() > 0 && path.charAt(0) == '/') {
            return path.substring(1);
        }
        return path;
    }
}

